% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flip.R
\name{rray_flip}
\alias{rray_flip}
\title{Flip an rray along a dimension}
\usage{
rray_flip(x, axis)
}
\arguments{
\item{x}{An rray.}

\item{axis}{An integer of size \code{1} specifying the dimension to flip.}
}
\value{
\code{x} but with reversed elements along \code{axis}.
}
\description{
\code{rray_flip()} reverses the elements of an rray along a single dimension.
}
\details{
Dimension names are flipped as well.
}
\examples{

x <- rray(1:10, c(5, 2))
x <- rray_set_row_names(x, letters[1:5])
x <- rray_set_col_names(x, c("c1", "c2"))

rray_flip(x, 1)

rray_flip(x, 2)

}
