% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.rrmix}
\alias{plot.tune.rrmix}
\title{Visualize rrmix Objects}
\usage{
\method{plot}{rrmix}(
  x,
  pch.L = 1,
  pch.F = 2,
  col.L = "red",
  col.F = "blue",
  lty.L = 1,
  lty.F = 1,
  type = "b",
  ...
)

\method{plot}{tune.rrmix}(
  x,
  metric = c("bic", "soft.class.err", "hard.class.err", "est.err", "pred.err"),
  col = "blue",
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  swapxy = FALSE,
  transform.x = NULL,
  transform.y = NULL,
  transform.z = NULL,
  color.palette = hsv_palette(),
  nlevels = 20,
  ...
)
}
\arguments{
\item{x}{an object of class \code{rrmix} or \code{tune.rrmix}.}

\item{pch.L}{symbol to use for displaying log-likelihood.}

\item{pch.F}{symbol to use for displaying penalized log-likelihood.}

\item{col.L}{color code or name for displaying log-likelihood.}

\item{col.F}{color code or name displaying penalized log-likelihood.}

\item{lty.L}{line type for displaying log-likelihood.}

\item{lty.F}{line type for displaying penalized log-likelihood.}

\item{type}{character indicating the type of plotting.}

\item{...}{Other arguments for future usage.}

\item{metric}{performance metric to use for finding best `rrmix' model.
`soft.class.err', `hard.class.err', `est.err', and `pred.err' can only be
used when true parameter values are known.}

\item{col}{the color(s) of the surface facets. Transparent colors are ignored.}

\item{main}{main title.}

\item{xlab}{title for the x-axis.}

\item{ylab}{title for the y-axis.}

\item{swapxy}{if TRUE, the parameter axes are swaped (only used in case of
two parameters).}

\item{transform.x, transform.y, transform.z}{functions to transform the parameters
(x and y) and the error measures (z). Ignored if NULL.}

\item{color.palette}{color palette used in contour plot.}

\item{nlevels}{number of levels used in contour plot.}
}
\description{
S3 methods visualizing results for some objects generated by \code{rrmix} and \code{tune.rrmix}.
}
