% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_assignments.R
\name{make_assignments}
\alias{make_assignments}
\title{Make a list of assignments, applying many functions to many columns.}
\usage{
make_assignments(columns, funs, ..., sep = "_", prefix = TRUE)
}
\arguments{
\item{columns}{character, vector of column names to take values from.}

\item{funs}{character, names of functions to apply.}

\item{...}{not used, forced later parameters to bind by name}

\item{sep}{character, naming separator}

\item{prefix}{logical, if TRUE place function names prior, else after in results.}
}
\description{
Make a list of assignments, applying each function to each column named.
Intended to be used as an argument in \code{extend_se()} or \code{project_se()}.
}
\examples{

assignments <- make_assignments(c('x', 'y'), c('mean', med = 'median'))
print(assignments)
ops <- mk_td('d', c('x', 'y')) \%.>\% project_se(., assignments)
cat(format(ops))

}
