% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialize_node.R
\name{materialize_node}
\alias{materialize_node}
\title{Create a materialize node.}
\usage{
materialize_node(
  source,
  table_name = (wrapr::mk_tmp_name_source("rquerymn"))(),
  ...,
  qualifiers = NULL
)
}
\arguments{
\item{source}{source to work from (relop node)}

\item{table_name}{character, name of caching table}

\item{...}{not used, force later argument to bind by name}

\item{qualifiers}{optional named ordered vector of strings carrying additional db hierarchy terms, such as schema.}
}
\value{
relop materialize_node
}
\description{
Write results into a specified table.  Result is transient, lives only for the duration of the
pipeline calculation.  This node is only used to break up or un-nest calculations, not for value sharing or
re-use.
}
\details{
Note this node can not be used in multiple paths in the same rel_op tree as it re-uses table names and
re-computes each time called.
}
\seealso{
\code{\link{rsummary_node}}, \code{\link{non_sql_node}}
}
