% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_expr.R
\name{order_expr}
\alias{order_expr}
\alias{order_expr_nse}
\title{Make a order_expr node.}
\usage{
order_expr(source, expr, env = parent.frame())

order_expr_nse(source, expr, env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{expr}{expression to order_expr.}

\item{env}{environment to look to.}
}
\value{
select columns node.
}
\description{
order_expr() uses bquote() .()-style escaping.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2, z = 3))
  TARGETCOL = as.name("AUC")
  optree <- order_expr(d, .(TARGETCOL)/R2) \%.>\%
    select_columns(., "R2")
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
