% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile.R
\name{quantile_node}
\alias{quantile_node}
\title{Compute quantiles over non-NULL values
(without interpolation, needs a database with window functions).}
\usage{
quantile_node(source, cols = NULL, ...,
  probs_name = "quantile_probability", probs = seq(0, 1, 0.25),
  tmp_name_source = wrapr::mk_tmp_name_source("qn"), temporary = TRUE)
}
\arguments{
\item{source}{source to select from (relop or data.frame).}

\item{cols}{character, compute quantiles for these columns (NULL indicates all columns).}

\item{...}{force later arguments to be bound by name}

\item{probs_name}{character, column name to write probs in.}

\item{probs}{numeric quantiles to compute}

\item{tmp_name_source}{wrapr::mk_tmp_name_source(), temporary name generator.}

\item{temporary}{logical, if TRUE use temporary tables}
}
\value{
table of quantiles
}
\description{
Please see \url{https://github.com/WinVector/rquery/blob/master/extras/Summary_Example.md} for an example.
}
\details{
This is a non_sql_node, so please see \code{\link{non_sql_node}} for some of the issues for this node type.
}
\seealso{
\code{\link{quantile_cols}}, \code{\link{rsummary}}, \code{\link{non_sql_node}}
}
