% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_design.R
\name{expand_grid}
\alias{expand_grid}
\title{Cross product vectors in database.}
\usage{
expand_grid(db, values, ..., temporary = TRUE,
  table_name = (wrapr::mk_tmp_name_source("eg"))())
}
\arguments{
\item{db}{database handle}

\item{values}{named list of value vectors.}

\item{...}{force later arguments to bind by name.}

\item{temporary}{logical if TRUE try to make temporary table.}

\item{table_name}{name to land result as.}
}
\value{
table handle.
}
\description{
Cross product vectors in database.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) &&
    requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  values <- list(nums = 1:3, lets = c("a", "b"))
  res <- expand_grid(my_db, values)
  print(res)
  execute(my_db, res)
  DBI::dbDisconnect(my_db)
}

}
