% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_source.R
\name{db_td}
\alias{db_td}
\alias{dbi_table}
\title{Construct a table description from a database source.}
\usage{
db_td(db, table_name, ..., qualifiers = NULL)

dbi_table(db, table_name, ..., qualifiers = NULL)
}
\arguments{
\item{db}{database connection}

\item{table_name}{name of table}

\item{...}{not used, force later argument to bind by name}

\item{qualifiers}{optional named ordered vector of strings carrying additional db hierarchy terms, such as schema.}
}
\value{
a relop representation of the data
}
\description{
Build structures (table name, column names, and quoting
strategy) needed to represent data from a remote table.
}
\details{
Note: in examples we use \code{rq_copy_to()} to create data.  This is only for the purpose of having
easy portable examples.  With big data the data is usually already in the remote database or
Spark system. The task is almost always to connect and work with this pre-existing remote data
and the method to do this is \code{db_td}
which builds a reference to a remote table given the table name.
}
\section{Functions}{
\itemize{
\item \code{dbi_table}: old name for db_td
}}

\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  rq_copy_to(my_db,
              'd',
              data.frame(AUC = 0.6, R2 = 0.2),
              overwrite = TRUE,
              temporary = TRUE)
  d <- db_td(my_db, 'd')
  print(d)
  sql <- to_sql(d, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  cols <- columns_used(d)
  print(cols)

  sql2 <- to_sql(d, my_db, using = "AUC")
  cat(sql2)
  print(DBI::dbGetQuery(my_db, sql2))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{mk_td}}, \code{\link{rq_copy_to}}, \code{\link{materialize}}, \code{\link{execute}}, \code{\link{to_sql}}
}
