% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_controller.R
\name{key_inspector_all_cols}
\alias{key_inspector_all_cols}
\title{Return all columns as guess at preferred primary keys.}
\usage{
key_inspector_all_cols(db, tablename)
}
\arguments{
\item{db}{database handle}

\item{tablename}{character, name of table}
}
\value{
map of keys to keys
}
\description{
Return all columns as guess at preferred primary keys.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  DBI::dbWriteTable(my_db,
                    "d",
                    data.frame(x=1:3, y=NA))
  print(key_inspector_all_cols(my_db, "d"))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{describe_tables}
}
