% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_indicator.R
\name{set_indicator}
\alias{set_indicator}
\title{Build an in set indicator.}
\usage{
set_indicator(source, rescol, testcol, testvalues)
}
\arguments{
\item{source}{optree relnode or data.frame.}

\item{rescol}{name of column to land indicator in.}

\item{testcol}{name of column to check.}

\item{testvalues}{values to check for.}
}
\value{
implementing optree or altered data.frame
}
\description{
Build an in set indicator.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(),
                          ":memory:")

  d <- dbi_copy_to(my_db, 'd',
                   data.frame(a = c("1", "2", "1", "3"),
                              b = c("1", "1", "3", "2"),
                              stringsAsFactors = FALSE),
                   temporary = TRUE,
                   overwrite = TRUE)
  # example
  set <- c("1", "2")
  op_tree <- d \%.>\%
    set_indicator(., "one_two", "a", set)
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))

  # cleanup
  DBI::dbDisconnect(my_db)
}

}
