% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_source.R
\name{table_source}
\alias{table_source}
\title{Table data source.}
\usage{
table_source(table_name, columns)
}
\arguments{
\item{table_name}{character, name of table}

\item{columns}{character, column names of table}
}
\value{
a relop representation of the data
}
\description{
Build structures (table name, column names, and quoting
strategy) needed to represent data from a remote table.
}
\details{
Generate a query that returns contents of a table, we
could try to eliminate this (replace the query with the table name),
but there are features one can work with with the query in place and
SQL optimizers likely make this zero-cost anyway.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbWriteTable(my_db,
                  'd',
                  data.frame(AUC = 0.6, R2 = 0.2),
                  overwrite = TRUE,
                  temporary = TRUE)
d <- table_source('d',
                  columns = c("AUC", "R2"))
print(d)
sql <- to_sql(d, my_db)
cat(sql)
DBI::dbGetQuery(my_db, sql)
DBI::dbDisconnect(my_db)

}
\seealso{
\code{\link{dbi_table}}
}
