% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_source.R
\name{dbi_copy_to}
\alias{dbi_copy_to}
\title{Local table to DBI data source.}
\usage{
dbi_copy_to(db, table_name, d, ..., overwrite = FALSE, temporary = TRUE,
  rowidcolumn = NULL)
}
\arguments{
\item{db}{database connection.}

\item{table_name}{name of table to create.}

\item{d}{data.frame to copy to database.}

\item{...}{force later argument to be by name}

\item{overwrite}{passed to \code{\link[DBI]{dbWriteTable}}.}

\item{temporary}{passed to \code{\link[DBI]{dbWriteTable}}.}

\item{rowidcolumn}{character, name to land row-ids.}
}
\value{
a relop representation of the data
}
\description{
Local table to DBI data source.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d <- dbi_copy_to(my_db, 'd',
                data.frame(AUC = 0.6, R2 = 0.2))
sql <- to_sql(d, my_db)
cat(sql)
DBI::dbDisconnect(my_db)

}
