% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop_table_source.R
\name{ex_data_table_step.relop_table_source}
\alias{ex_data_table_step.relop_table_source}
\title{Build a data source description.}
\usage{
\method{ex_data_table_step}{relop_table_source}(
  optree,
  ...,
  tables = list(),
  source_usage = NULL,
  source_limit = NULL,
  env = parent.frame()
)
}
\arguments{
\item{optree}{relop operations tree.}

\item{...}{not used, force later arguments to bind by name.}

\item{tables}{named list map from table names used in nodes to data.tables and data.frames.}

\item{source_usage}{list mapping source table names to vectors of columns used.}

\item{source_limit}{if not null limit all table sources to no more than this many rows (used for debugging).}

\item{env}{environment to work in.}
}
\description{
\code{data.table} based implementation.
Looks for tables first in \code{tables} and then in \code{env}.
Will accept any \code{data.frame} that can
be converted to \code{data.table}.
}
\examples{

dL <- build_frame(
    "x", "y" |
    2L , "b" |
    1L , "a" |
    3L , "c" )
rquery_pipeline <- local_td(dL)
dL \%.>\% rquery_pipeline

}
