% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop_null_replace.R
\name{ex_data_table_step.relop_null_replace}
\alias{ex_data_table_step.relop_null_replace}
\title{Replace NAs.}
\usage{
\method{ex_data_table_step}{relop_null_replace}(
  optree,
  ...,
  tables = list(),
  source_usage = NULL,
  source_limit = NULL,
  env = parent.frame()
)
}
\arguments{
\item{optree}{relop operations tree.}

\item{...}{not used, force later arguments to bind by name.}

\item{tables}{named list map from table names used in nodes to data.tables and data.frames.}

\item{source_usage}{list mapping source table names to vectors of columns used.}

\item{source_limit}{if not null limit all table sources to no more than this many rows (used for debugging).}

\item{env}{environment to work in.}
}
\description{
\code{data.table} based implementation.
}
\examples{

dL <- build_frame(
    "x", "y" |
    2L ,  5  |
    NA ,  7  |
    NA , NA )
rquery_pipeline <- local_td(dL) \%.>\%
  null_replace(., c("x", "y"), 0, note_col = "nna")
dL \%.>\% rquery_pipeline

}
