% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop_non_sql.R
\name{rq_df_funciton_node}
\alias{rq_df_funciton_node}
\title{Helper to build data.table capable non-sql nodes.}
\usage{
rq_df_funciton_node(
  .,
  f,
  ...,
  f_db = NULL,
  columns_produced,
  display_form,
  orig_columns = FALSE
)
}
\arguments{
\item{.}{or data.frame input.}

\item{f}{function that takes a data.table to a data.frame (or data.table).}

\item{...}{force later arguments to bind by name.}

\item{f_db}{implementation signature: f_db(db, incoming_table_name, outgoing_table_name, nd, ...) (db being a database handle). NULL defaults to using f.}

\item{columns_produced}{character columns produces by f.}

\item{display_form}{display form for node.}

\item{orig_columns}{orig_columns, if TRUE assume all input columns are present in derived table.}
}
\value{
relop non-sql node implementation.
}
\description{
Helper to build data.table capable non-sql nodes.
}
\examples{

# a node generator is something an expert can
# write and part-time R users can use.
grouped_regression_node <- function(., group_col = "group", xvar = "x", yvar = "y") {
  force(group_col)
  formula_str <- paste(yvar, "~", xvar)
  f <- function(df, nd = NULL) {
    dlist <- split(df, df[[group_col]])
    clist <- lapply(dlist,
                    function(di) {
                      mi <- lm(as.formula(formula_str), data = di)
                      ci <- as.data.frame(summary(mi)$coefficients)
                      ci$Variable <- rownames(ci)
                      rownames(ci) <- NULL
                      ci[[group_col]] <- di[[group_col]][[1]]
                      ci
                    })
    data.table::rbindlist(clist)
  }
  columns_produced =
     c("Variable", "Estimate", "Std. Error", "t value", "Pr(>|t|)", group_col)
  rq_df_funciton_node(
    ., f,
    columns_produced = columns_produced,
    display_form = paste0(yvar, "~", xvar, " grouped by ", group_col))
}

# work an example
set.seed(3265)
d <- data.frame(x = rnorm(1000),
                y = rnorm(1000),
                group = sample(letters[1:5], 1000, replace = TRUE),
                stringsAsFactors = FALSE)

rquery_pipeline <- local_td(d) \%.>\%
  grouped_regression_node(.)

cat(format(rquery_pipeline))

ex_data_table_step(rquery_pipeline)

}
\seealso{
\code{\link[rqdatatable]{ex_data_table_step.relop_non_sql}}, \code{\link{rq_df_grouped_funciton_node}}
}
