% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop_set_indicator.R
\name{ex_data_table.relop_set_indicator}
\alias{ex_data_table.relop_set_indicator}
\title{Implement set_indicatoroperator.}
\usage{
\method{ex_data_table}{relop_set_indicator}(optree, ..., tables = list(),
  source_usage = NULL, source_limit = NULL, env = parent.frame())
}
\arguments{
\item{optree}{relop operations tree.}

\item{...}{not used, force later arguments to bind by name.}

\item{tables}{named list map from table names used in nodes to data.tables and data.frames.}

\item{source_usage}{list mapping source table names to vectors of columns used.}

\item{source_limit}{if not null limit all table sources to no more than this many rows (used for debugging).}

\item{env}{environment to work in.}
}
\description{
\code{data.table} based implementation.
}
\examples{

d <- data.frame(a = c("1", "2", "1", "3"),
                b = c("1", "1", "3", "2"),
                q = 1,
                stringsAsFactors = FALSE)
set <- c("1", "2")
op_tree <- local_td(d) \%.>\%
  set_indicator(., "one_two", "a", set) \%.>\%
  set_indicator(., "z", "a", c())
ex_data_table(op_tree)[]


}
