% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_custom_models.R
\name{validate_survival_model}
\alias{validate_survival_model}
\title{Tests that a custom survival object has the required attributes
for use in the \code{prevalence} function.}
\usage{
validate_survival_model(object, data, timeframe = 3652,
  sample_size = 10)
}
\arguments{
\item{object}{The custom survival object.}

\item{data}{Registry data in the form of a data frame. Ideally
will be the same source that will be used for the prevalence
estimation later on.}

\item{timeframe}{Maximum time at which to test survival probability in days.
If not supplied then chooses random values over a period of 10 years, which
should be suitable for many diseases.}

\item{sample_size}{The number of randomly drawn individuals to predict
sample size for.}
}
\value{
None. Instead, messages get displayed to the
console.
}
\description{
Runs checks to assess whether a custom survival model is
suitable for use in \code{prevalence}. Provides useful
diagnostic messages if any issues are encountered.
}
