% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgtrajVacuum.R
\name{pgtrajVacuum}
\alias{pgtrajVacuum}
\title{pgtrajVacuum
VACUUM a pgtraj schema.}
\usage{
pgtrajVacuum(conn, schema = "traj", full = FALSE, verbose = FALSE,
  analyze = TRUE)
}
\arguments{
\item{conn}{Connection object created with RPostgreSQL}

\item{schema}{String. Name of the schema that stores or will store
the pgtraj data model.}

\item{full}{Logical. Whether to perform a "full" vacuum, which can
reclaim more space, but takes much longer and exclusively
locks the table.}

\item{verbose}{Logical. Whether to print a detailed vacuum
activity report for each table.}

\item{analyze}{Logical. Whether to update statistics used by the
planner to determine the most efficient way to execute a query
(default to \code{TRUE}).}
}
\value{
\code{TRUE} on success.
}
\description{
Performs a VACUUM (garbage-collect and optionally analyze) on all
the tables of a \code{traj} schema.
}
\examples{
\dontrun{
  # Vacuum analyze all tables in pgtraj schema with default name "traj"
  pgtrajVacuum(conn)
}
}
\author{
Balázs Dukai \email{balazs.dukai@gmail.com}
}

