% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgPostGIS.R
\name{pgPostGIS}
\alias{pgPostGIS}
\title{Check and create PostGIS extension.}
\usage{
pgPostGIS(conn, topology = FALSE, tiger = FALSE, sfcgal = FALSE,
  display = TRUE, exec = TRUE)
}
\arguments{
\item{conn}{A connection object (required, even if \code{exec =
FALSE}).}

\item{topology}{Logical. Whether to check/install the Topology
extension.}

\item{tiger}{Logical. Whether to check/install the Tiger Geocoder
extension.}

\item{sfcgal}{Logical. Whether to check/install the SFCGAL
extension.}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}
}
\value{
\code{TRUE} if PostGIS is installed.
}
\description{
The function checks for the availability of the PostGIS extension,
and if it is available, but not installed, install
it. Additionnaly, can also install Topology, Tiger Geocoder and
SFCGAL extensions.
}
\examples{
## 'exec = FALSE' does not install any extension, but nevertheless
## check for available and installed extensions:
\dontrun{
    pgPostGIS(con, topology = TRUE, tiger = TRUE, sfcgal = TRUE,
        exec = FALSE)
}
}
\author{
Mathieu Basille \email{basille@ufl.edu}
}

