% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plum.R
\name{Plum}
\alias{Plum}
\title{Main 210Pb age-depth modelling function}
\usage{
Plum(
  core = "HP1C",
  thick = 1,
  otherdates = NA,
  coredir = "",
  phi.shape = 2,
  phi.mean = 50,
  s.shape = 5,
  s.mean = 10,
  Al = 0.1,
  date.sample = c(),
  n.supp = c(),
  ra.case = c(),
  Bqkg = TRUE,
  seed = NA,
  prob = 0.95,
  d.min = 0,
  d.max = NA,
  d.by = 1,
  depths.file = FALSE,
  depths = c(),
  depth.unit = "cm",
  age.unit = "yr",
  unit = depth.unit,
  acc.shape = 1.5,
  acc.mean = 10,
  mem.strength = 10,
  mem.mean = 0.5,
  boundary = NA,
  hiatus.depths = NA,
  hiatus.max = 10000,
  add = c(),
  after = 1e-04/thick,
  cc = 1,
  cc1 = "IntCal20",
  cc2 = "Marine20",
  cc3 = "SHCal20",
  cc4 = "ConstCal",
  ccdir = "",
  postbomb = 0,
  delta.R = 0,
  delta.STD = 0,
  t.a = 3,
  t.b = 4,
  normal = FALSE,
  suggest = TRUE,
  reswarn = c(10, 200),
  remember = TRUE,
  ask = TRUE,
  run = TRUE,
  defaults = "defaultPlum_settings.txt",
  sep = ",",
  dec = ".",
  runname = "",
  slump = c(),
  BCAD = FALSE,
  ssize = 2000,
  th0 = c(),
  burnin = min(1500, ssize),
  MinAge = c(),
  MaxAge = c(),
  cutoff = 0.001,
  rounded = 1,
  plot.pdf = TRUE,
  dark = 1,
  date.res = 100,
  age.res = 200,
  close.connections = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{core}{Name of the core, given using quotes. Defaults to one of the cores provided with rplum, \code{core="HP1C"} also reported by Aquino-Lopez et al. (2018). Also available is LL14, a core kindly provided by Dr Lysanna Anderson (USGS). LL14 has ra-226 data (so can be run with \code{ra.case=1} or \code{ra.case=2}, see below), and also has additional C-14 and cal BP data (these can be added using \code{otherdates="LL14_14C.csv"}). The original LL14 core has more 14C data than provided here (for reasons of brevity).
To run your own core, produce a .csv file with the dates as outlined in the manual, add a folder with the core's name to the default directory for cores (see \code{coredir}), and save the .csv file there. For example, the file's location and name could be \code{Plum_runs/MyCore/MyCore.csv}. Then run Plum as follows: \code{Plum("MyCore")}.
Note that for Pb-210 data, the depth in the .csv should be the bottom of the slice, not the mid-point. (For any non-Pb data, depths are the midpoints of their slices). Also make sure that the thickness and density are given correctly for each Pb-210 data point.}

\item{thick}{Plum will divide the core into sections of equal thickness specified by thick (default \code{thick=1}).}

\item{otherdates}{Name of (optional) file with radiocarbon dates. This file should have the same format as the one used for rbacon. For example, \code{Bacon("LL14", otherdates="LL14_14C.csv")}.}

\item{coredir}{Folder where the core's files \code{core} are and/or will be located. This will be a folder with the core's name, within either the folder \code{coredir='Plum_runs/'}, or the folder Cores/ if it already exists within R's working directory, or a custom-built folder. For example, use \code{coredir="."} to place the core's folder within the current working directory, or \code{coredir="F:"} if you want to put the core's folder and files on a USB drive loaded under F:.
Thinner (and thus more) sections will result in smoother age-models, but too many sections can cause `run-away' models.}

\item{phi.shape}{Shape parameter of the prior gamma distribution used for the influx of Pb-210 to the sediment, default \code{phi.shape=2}.}

\item{phi.mean}{Mean parameter of the prior gamma distribution used for the influx of Pb-210 to the sediment, default \code{phi.mean=50}.}

\item{s.shape}{Shape parameter of the prior gamma distribution used for the supported Pb-210 to the sediment, default \code{s.shape=5}.}

\item{s.mean}{Mean parameter of the prior gamma distribution used for the supported Pb-210 to the sediment, default \code{s.mean=10}.}

\item{Al}{Parameter used to limit the chronologies described in Aquino-Lopez et al. (2018) for the minimum distinguishable unsupported activity; default \code{Al=0.1}.}

\item{date.sample}{Date at which the core was measured for Pb-120. This date will be used as a surface date and is assumed to have no uncertainty, \code{date.sample=NA}. If the date is not provided (in the .csv file or as \code{date.sample}), Plum will ask for it.}

\item{n.supp}{This value will delete n.supp data points from the deepest part of the core, and these points will then be used exclusively to estimate the supported activity. If this option is used, a constant supported Pb-210 will be assumed, \code{n.supp=-1}.}

\item{ra.case}{How to use radium-226 measurements if they are provided in the core's .csv file. 1 = assume constant radium, 2 = assume varying radium and use the radium measurements as individual estimates of supported Pb-210. If no radium measurements are present, use \code{ra.case=0}.}

\item{Bqkg}{This variable indicates whether total Pb-210 is expressed in Bq/kg (default; \code{Bqkg=TRUE}) or dpm/g if set to FALSE.}

\item{seed}{Seed used for C++ executions; if it is not assigned then the seed is set by system. Default \code{seed=NA}.}

\item{prob}{Confidence interval to report. This should lie between 0 and 1, default \code{prob=0.95} (95 \%).}

\item{d.min}{Minimum depth of age-depth model (use this to extrapolate to depths higher than the top dated depth).}

\item{d.max}{Maximum depth of age-depth model (use this to extrapolate to depths below the bottom dated depth).}

\item{d.by}{Depth intervals at which ages are calculated. Defaults to \code{d.by=1}.}

\item{depths.file}{By default, Plum will calculate the ages for the depths \code{d.min} to \code{d.max} in steps of \code{d.by}.
If \code{depths.file=TRUE}, Plum will read a file containing the depths for which you require ages.
This file, containing the depths in a single column without a header, should be stored within \code{coredir},
and its name should start with the core's name and end with `_depths.txt'. Then specify \code{depths.file=TRUE} (default \code{FALSE}). See also \code{depths}.}

\item{depths}{By default, Plum will calculate the ages for the depths \code{d.min} to \code{d.max} in steps of \code{d.by}.
Alternative depths can be provided as, e.g., \code{depths=seq(0, 100, length=500)} or as a file, e.g., \code{depths=read.table("CoreDepths.txt"}. See also \code{depths.file}}

\item{depth.unit}{Units of the depths. Defaults to \code{depth.unit="cm"}.}

\item{age.unit}{Units of the ages. Defaults to \code{age.unit="yr"}.}

\item{unit}{Deprecated and replaced by \code{depth.unit}.}

\item{acc.shape}{The prior for the accumulation rate consists of a gamma distribution with two parameters.
Its shape is set by acc.shape (default \code{acc.shape=1.5}; higher values result in more peaked shapes).}

\item{acc.mean}{The accumulation rate prior consists of a gamma distribution with two parameters. Its mean is set by acc.mean (default \code{acc.mean=10} yr/cm (or whatever age or depth units are chosen),
which can be changed to, e.g., 5, 10 or 50 for different kinds of deposits). Multiple values can be given in case of hiatuses or boundaries, e.g., Plum(hiatus.depths=23, acc.mean=c(5,20))}

\item{mem.strength}{The prior for the memory (dependence of accumulation rate between neighbouring depths) is a beta distribution, which looks much like the gamma distribution.
but its values are always between 0 (no assumed memory) and 1 (100\% memory). Its default settings of \code{mem.strength=10}
(higher values result in more peaked shapes) allow for a large range of posterior memory values.}

\item{mem.mean}{The prior for the memory is a beta distribution, which looks much like the gamma distribution but
its values are always between 0 (no assumed memory) and 1 (100\% memory). Its default settings of \code{mem.mean=0.5}
allow for a large range of posterior memory values.}

\item{boundary}{The assumed depths of any boundary, which divides sections of different accumulation rate regimes (e.g., as indicated by major change in the stratigraphy). No hiatus is assumed between these sections, and memory is reset crossing the boundary. Different accumulation priors can be set for the sections above and below the boundary, e.g., \code{acc.mean=c(5, 20)}. See also \code{hiatus.depths}, \code{mem.mean}, \code{acc.mean} and \code{acc.shape}. Setting many boundaries might not work, and having more than one boundary per model section (see \code{'thick'}) might not work either.}

\item{hiatus.depths}{The assumed depths for any hiatus should be provided as, e.g.,
\code{hiatus.depths=20} for one at 20cm depth, and \code{hiatus.depths=c(20,40)} for two hiatuses at 20 and 40 cm depth.}

\item{hiatus.max}{The prior for the maximum length of the hiatus. Hiatus length is a uniform distribution, with equal probabilities between 0 and \code{hiatus.max} yr (or whatever other \code{age.unit} is chosen).}

\item{add}{Add a value to the maximum hiatus length if a boundary is chosen. Defaults to 100 yr (or whatever other age unit is chosen). Can be adapted if Plum complains that the parameters are out of support.}

\item{after}{Sets a short section above and below hiatus.depths within which to calculate ages. For internal calculations - do not change.}

\item{cc}{Calibration curve for C-14 dates: \code{cc=1} for IntCal20 (northern hemisphere terrestrial), \code{cc=2} for Marine20 (marine),
\code{cc=3} for SHCal20 (southern hemisphere terrestrial). For dates that are already on the cal BP scale use \code{cc=0}.}

\item{cc1}{For northern hemisphere terrestrial 14C dates (IntCal20).}

\item{cc2}{For marine 14C dates (Marine20).}

\item{cc3}{For southern hemisphere 14C dates (SHCal20).}

\item{cc4}{Use an alternative curve (3 columns: cal BP, 14C age, error, separated by white spaces and saved as a plain-text file). See \code{ccdir}.}

\item{ccdir}{Directory where the calibration curves for C14 dates \code{cc} are located. By default \code{ccdir=""} since they are loaded into R's memory.
For example, use \code{ccdir="."} to choose current working directory, or \code{ccdir="Curves/"} to choose sub-folder \code{Curves/}. Note that all calibration curves should reside in the same directory. If you want to add a custom-built curve, put it in the directory where the default calibration curves are (probably \code{list.files(paste0(.libPaths(), "/IntCal/extdata/"))}).
Alternatively produce a new folder, and add your curve as well as the default calibration curves there (cc1, cc2 and cc3; e.g., \code{write.table(copyCalibrationCurve(1), "./3Col_intcal20.14C", sep="\t")}.)}

\item{postbomb}{Use a postbomb curve for negative (i.e. postbomb) 14C ages. \code{0 = none, 1 = NH1, 2 = NH2, 3 = NH3, 4 = SH1-2, 5 = SH3}}

\item{delta.R}{Mean of core-wide age offsets (e.g., regional marine offsets).}

\item{delta.STD}{Error of core-wide age offsets (e.g., regional marine offsets).}

\item{t.a}{The dates are treated using the student's t distribution by default (\code{normal=FALSE}).
The student's t-distribution has two parameters, t.a and t.b, set at 3 and 4 by default (see Christen and Perez, 2010).
If you want to assign narrower error distributions (more closely resembling the normal distribution), set t.a and t.b at for example 33 and 34 respectively (e.g., for specific dates in your .csv file).
For symmetry reasons, t.a must always be equal to t.b-1.}

\item{t.b}{The dates are treated using the student's t distribution by default (\code{normal=FALSE}).
The student's t-distribution has two parameters, t.a and t.b, set at 3 and 4 by default (see Christen and Perez, 2010).
If you want to assign narrower error distributions (more closely resembling the normal distribution), set t.a and t.b at for example 33 and 34 respectively (e.g., for specific dates in your .csv file).
For symmetry reasons, t.a must always be equal to t.b-1.}

\item{normal}{By default, Plum uses the student's t-distribution to treat the dates. Use \code{normal=TRUE} to use the normal/Gaussian distribution. This will generally give higher weight to the dates.}

\item{suggest}{If initial analysis of the data indicates abnormally slow or fast accumulation rates, Plum will suggest to change the prior.
Also, if the length of the core would cause too few or too many sections with the default settings, Plum will suggest an alternative section thickness \code{thick}, and it will suggest approaches to estimating supported Pb-120. 
Accept these suggested alternative settings by typing "y" (or "yes please" if you prefer to be polite), or leave as is by typing "n" (or anything else, really). To get rid of these suggestions, use \code{suggest=FALSE}.}

\item{reswarn}{Plum will warn you if the number of sections lies outside the safe range (default between 10 and 200 sections;
\code{reswarn=c(10,200)}). Too few sections could lead to an `elbowy' model while with too many sections the modelling process can get lost,
 resulting in age-models far away from the dated depths.}

\item{remember}{Plum will try to remember which settings you have applied to your cores (default \code{remember=TRUE}). If you run into inconsistencies or other problems,
try running your core again with \code{remember=FALSE}, or, start cleanly by typing \code{Plum.cleanup()}.}

\item{ask}{By default Plum will ask you to confirm that you want to run the core with the provided settings. Disable this using \code{ask=FALSE} (e.g., for batch runs).}

\item{run}{In order to load an existing Plum run instead of producing a new one, you can use \code{run=FALSE}.}

\item{defaults}{Name of the file containing settings for the core. For internal use only - do not change.}

\item{sep}{Separator between the fields of the plain text file containing the dating information. Default \code{sep=","}.}

\item{dec}{Character for decimal points. Default to \code{dec="."}.}

\item{runname}{Text to add to the corename for specific runs, e.g., \code{runname="MyCore_Test1"}.}

\item{slump}{Upper and lower depths of any sections of assumed abrupt accumulation, that require excising before age-modelling (and adding after age-modelling). Requires pairs of depths, e.g., \code{slump=c(10,15,60,67)} for slumps at 67-60 and 15-10 cm core depth.}

\item{BCAD}{The calendar scale of graphs and age output-files is in cal BP (calendar or calibrated years before the present, where the present is AD 1950) by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{ssize}{The approximate amount of iterations to store at the end of the MCMC run. Default 2000; decrease for faster (but less reliable) runs or increase for cores where the MCMC mixing (panel at upper-left corner of age-model graph) appears problematic.}

\item{th0}{Starting years for the MCMC iterations.}

\item{burnin}{Amount of initial, likely sub-optimal MCMC iterations that will be removed.}

\item{MinAge}{Minimum age limit for Plum runs, default at current year in cal BP. To set plot limits, use \code{yr.min} instead.}

\item{MaxAge}{Maximum age limit for Plum runs, default at 1,000,000 cal BP. To set plot limits, use \code{yr.max} instead.}

\item{cutoff}{Avoid plotting very low probabilities of date distributions (default \code{cutoff=0.001}).}

\item{rounded}{Rounding of calendar years. Defaults to 1 decimal.}

\item{plot.pdf}{Produce a pdf file of the age-depth plot. Defaults to \code{plot.pdf=TRUE} after a Plum run.}

\item{dark}{Darkness of the greyscale age-depth model. The darkest grey value is \code{dark=1} by default.
Lower values will result in lighter grey but values >1 are not allowed.}

\item{date.res}{Date distributions are plotted using \code{date.res=100} segments by default.}

\item{age.res}{Resolution or amount of greyscale pixels to cover the age scale of the age-model plot. Default \code{yr.res=200}.}

\item{close.connections}{Internal option to close connections after a run. Default \code{close.connections=TRUE}.}

\item{verbose}{Provide feedback on what is happening (default \code{verbose=TRUE}).}

\item{...}{options for the age-depth graph. See \link{agedepth} and \link{calib.plot}}
}
\value{
An age-depth model graph, its age estimates, and a summary.
}
\description{
This is the main age-depth modelling function of the rplum package for 210Pb age-modelling.
}
\details{
Plum is an approach to age-depth modelling that uses Bayesian statistics in order to reconstruct
accumulation histories for 210Pb-dated deposits by taking into account prior information, and can combine 210Pb, radiocarbon and other dates (Aquino et al. 2018).

Plum handles 210Pb and other dated depths within in a core, by dividing a core into many thin vertical sections (by default of \code{thick=1} cm thickness),
and through millions of Markov Chain Monte Carlo (MCMC) iterations estimates the flux of 210Pb and supported 210Pb, as well as 
the accumulation rate (in years/cm; so more correctly, sedimentation times) for each of these sections.
Combined with an estimated starting date for the first section, these accumulation rates and values for 210Pb then form the age-depth and 210Pb model.
The accumulation rates are constrained by prior information on the accumulation rate (\code{acc.mean, acc.shape)} and its
variability between neighbouring depths, or "memory" (\code{mem.mean, mem.strength}). Hiatuses can be introduced as well,
also constrained by prior information (\code{hiatus.max}). The 210Pb flux (phi) and supported 210Pb (s) are constrained by priors \code{phi.mean, phi.shape, s.mean and s.shape}.  

Although Plum was developed for 210Pb dates, it can also include absolute dates (e.g., 14C, OSL, tephra or other dates on a calendar scale).
Radiocarbon dates should be calibrated using either IntCal20
(for terrestrial northern hemisphere material; Reimer et al., 2020), Marine20 (for marine dates; Hughen et al., 2020),
SHCal20 (for southern hemisphere dates; Hogg et al., 2020) or any other calibration curve (see below), while modern 14C
dates are calibrated using one of the post-bomb calibration curves (NH1, NH2 or NH3 for the northern hemisphere,
SH1-2 or SH3 for the southern hemisphere; Hua et al., 2013). See \url{http://calib.org/CALIBomb/} if you are unsure which
postbomb curve you need. If Plum finds postbomb dates (negative 14C ages) and you haven't specified a postbomb curve,
you will be prompted. Provide postbomb curves as, e.g., \code{postbomb=1} for the NH1 postbomb curve (2 for NH2, 3 for NH3,
4 for SH1-2, 5 for SH3).

For calendar dates, i.e. dates that are already on the calendar scale and thus should not be calibrated, set\code{cc=0}. 
Plum also needs the date of sampling, in AD (\code{date.sample}).
}
\examples{
\donttest{
  Plum(ask=FALSE, run=FALSE, coredir=tempfile(), date.sample=2018.5, ra.case=0, n.supp=3)
  agedepth(age.res=50, d.res=50)
}
}
\references{
Aquino-Lopez, M.A., Blaauw, M., Christen, J.A., Sanderson, N., 2018. Bayesian analysis of 210Pb dating. Journal of Agricultural, Biological, and Environmental Statistics 23, 317-333

Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive gamma process. Bayesian Analysis 6 (2011), no. 3, 457--474.

Christen, J.A., Perez E., S., 2010. A new robust statistical model for radiocarbon data. Radiocarbon 51, 1047-1059.

Hogg et al. 2020 SHCal20 Southern Hemisphere calibration, 0-55,000 years cal BP. Radiocarbon 62. doi: 10.1017/RDC.2020.59

Hua, Q., Barbetti, M., Rakowski, A.Z., 2013. Atmospheric radiocarbon for the period 1950-2010.
Radiocarbon 55(4), <doi:10.2458/azu_js_rc.v55i2.16177>.

Hughen et al. 2020 Marine20-the marine radiocarbon age calibration curve (0-55,000 cal BP). Radiocarbon 62. doi: 10.1017/RDC.2020.68.

Jones, V.J., Stevenson, A.C., Battarbee, R.W., 1989. Acidification of lakes in Galloway, south west Scotland - a diatom and pollen study of the post-glacial history of the Round Loch of Glenhead.
Journal of Ecology 77: 1-23.

Reimer et al., 2020. The IntCal20 Northern Hemisphere radiocarbon age calibration curve (0–55 cal kBP). Radiocarbon 62. doi: 10.1017/RDC.2020.41
}
\author{
Maarten Blaauw, J. Andres Christen, Marco A. Aquino L.
}
