% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpivotTable.R
\name{rpivotTable}
\alias{rpivotTable}
\title{pivottable.js in R}
\usage{
rpivotTable(data, rows = NULL, cols = NULL, aggregatorName = NULL,
  vals = NULL, rendererName = NULL, sorter = NULL, exclusions = NULL,
  inclusions = NULL, ..., width = NULL, height = NULL)
}
\arguments{
\item{data}{data.frame or data.table (R>=1.9.6 for safety) with data to use in the pivot table}

\item{rows}{String name of the column in the data.frame to prepopulate
the \strong{rows} of the pivot table.}

\item{cols}{String name of the column in the data.frame to prepopulate
the \strong{columns} of the pivot table.}

\item{aggregatorName}{String name of the pivottable.js aggregator to prepopulate the pivot table.}

\item{vals}{String name of the column in the data.frame to use with \code{aggregatorName}. Must be additive (i.e a number).}

\item{rendererName}{List name of the renderer selected, e.g. Table, Heatmap, Treemap etc.}

\item{sorter}{String name this allows to implement a javascript function to specify the ad hoc sorting of certain values. See vignette for an example.
It is especially useful with time divisions like days of the week or months of the year (where the alphabetical order does not work).}

\item{exclusions}{String this optional parameter allows to filter the members of a particular dimension "by exclusion". 
Using the 'Titanic' example, to display only the "1st", "2nd" and "3rd" members in the "Class" dimension, it is convenient to filter by exclusion using `exclusions=list(Class="Crew")`.
Please note that this only pre-selects the visible filter(s) on the pivot table: the other dimension members are still availabe for selection if needed.}

\item{inclusions}{List this optional parameter allows to filter the members of a particular dimension "by inclusion". 
Using the 'Titanic' example, to display only the "Crew" member in the "Class" dimension, it is convenient to filter by inclusion using `inclusions=list(Class="Crew")`.
Please note that this only pre-selects the visible filter(s) on the pivot table: the other dimension members are still availabe for selection if needed.}

\item{...}{list other \href{https://github.com/nicolaskruchten/pivottable/wiki/Parameters}{parameters} that
can be passed to \code{pivotUI}. See Nicolas's Wiki for more details.
A further example of parameter is onRefresh. This parameters (shiny-only) introduces a JS function that allows to get back server side the list of parameters selected by the user.
An example is: onRefresh=htmlwidgets::JS("function(config) { Shiny.onInputChange('myPivotData', config); }")
This setting makes available server-side a function input$myPivotData that gives back a list (of lists) with all the slice & dice parameters offered by pivottable.
See the example onRefresh-shiny.R for an example of how to use this feature.  
Example of usage could be:
These parameters could be saved and re-sent to the user.
Alternative they could be used to subset the data item for saving as csv.}

\item{width}{width parameter}

\item{height}{height parameter}
}
\description{
Use pivottable.js in R with the power and convenience of a
htmlwidget.
}
\examples{

 # use Titanic dataset provided in base R - simple creation with just data

 rpivotTable( Titanic ) 

 # prepopulate multiple columns and multiple rows
 
 rpivotTable( Titanic, rows = c("Class","Sex"), cols = c("Age","Survived" ) )
 
 
 # A more complete example:
 
 rpivotTable(
 Titanic,
 rows = "Survived",
 cols = c("Class","Sex"),
 aggregatorName = "Sum as Fraction of Columns",
 vals = "Freq",
 rendererName = "Table Barchart"
 )

# An example with inclusions and exclusions filters:

rpivotTable(
Titanic,
rows = "Survived",
cols = c("Class","Sex"),
aggregatorName = "Sum as Fraction of Columns",
inclusions = list( Survived = list("Yes")),
exclusions= list( Class = list( "Crew")),
vals = "Freq",
rendererName = "Table Barchart"
)




}

