% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inset.R
\name{phylopic_inset}
\alias{phylopic_inset}
\title{Add custom grob insets to a ggplot}
\usage{
phylopic_inset(grob, xmin = -Inf, xmax = Inf, ymin = -Inf, ymax = Inf)
}
\arguments{
\item{grob}{grob to display}

\item{xmin, xmax}{x location (in data coordinates) giving horizontal
location of grob}

\item{ymin, ymax}{y location (in data coordinates) giving vertical location
of grob}
}
\description{
This is identical to \code{\link[ggplot2:annotation_custom]{ggplot2::annotation_custom()}} but it works with all
coords.
}
\details{
Most useful for adding tables, inset plots, and other grid-based
decorations
}
\note{
\code{\link[=phylopic_inset]{phylopic_inset()}} expects the grob to fill the entire viewport
defined by \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax.} Grobs with a different
(absolute) size will be center-justified in that region. Inf values can
be used to fill the full plot panel (the default).
}
\keyword{internal}
