% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{image}
\alias{image}
\alias{image_get}
\alias{image_list}
\alias{image_timerange}
\alias{image_count}
\alias{image_data}
\title{Perform actions with images.}
\usage{
image_get(uuid, options = NULL, ...)

image_list(start = 1, length = 10, options = NULL, ...)

image_timerange(timestamp = "modified", from = NULL, to = NULL,
  options = NULL, ...)

image_count(...)

image_data(input, size)
}
\arguments{
\item{uuid}{One or more name UUIDs.}

\item{options}{(character) One or more of citationStart, html, namebankID, root, string,
type, uid, uri, and/or votes}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{start}{The index to start with. Using 0 starts with the most recently-submitted image.}

\item{length}{Number of images to list.}

\item{timestamp}{Either \code{modified} (to go by the last time the image file was modified)
or \code{submitted} (to go by the time the image was first submitted).}

\item{from}{timestamp string, in "YYYY-MM-DD-HH-MM-SS" format, telling the earliest time to
retrieve images for. All numbers past the year are optional. For example, these are
acceptable: "2011-10-29-20-30", "2011-10-29-20", "2011-10-29", "2011-10", and "2011".
Omitted numbers indicate the lowest possible value for that number, for example, "2011"
indicates "2011-01-01-00-00-00" (2011 January 1, midnight). Numbers in the string do not
need to be padded. For example, this is acceptable: "2011-1-1-0-0-0". The image list will
include any images dated at the indicated time.}

\item{to}{A date-time string, in "YYYY-MM-DD-HH-MM-SS" format, telling the earliest time to
retrieve images for. See the from parameter for more details on the format. The image list
will include any images dated up to, but not including, the indicated time.}

\item{input}{Either a vector of uuids or the output from the function \code{search_images}}

\item{size}{Height of the image, one of 64, 128, 256, 512, 1024, "thumb", or "icon"}
}
\description{
Perform actions with images.
}
\details{
I'm not adding methods for modifying images, including add, edit, updated, delete, and
transfer, because I can't imagine doing those things from R. Am I wrong?

Note: uid is always returned
}
\examples{
\dontrun{
# Get info on an image
uuid <- "9fae30cd-fb59-4a81-a39c-e1826a35f612"
image_get(uuid = uuid)
image_get(uuid = uuid, options=c('credit','pngFiles','taxa','canonicalName','string','uri','type'))
image_get(uuid = uuid, options=c('credit','licenseURL','pngFiles','submitted','submitter',
   'svgFile','taxa','canonicalName','string','uri','type','citationStart'))

# Count images in Phylopic database
image_count()
image_count(verbose = TRUE)

# Lists images in chronological order, from most to least recently modified
image_list(start=1, length=10)
image_list(start=1, length=10, options="taxa")

# Lists images within a given time range, from most to least recent
image_timerange(from="2013-05-11")
image_timerange(from="2013-05-11", to="2013-05-12")
image_timerange(from="2013-05-11", to="2013-05-12", options='credit')

# Get data for an image
## input uuids
toget <- c("c089caae-43ef-4e4e-bf26-973dd4cb65c5", "41b127f6-0824-4594-a941-5ff571f32378", 
   "9c6af553-390c-4bdd-baeb-6992cbc540b1")
image_data(toget, size = "64")
image_data(toget, size = "thumb")

## input the output from search_images
x <- search_text(text = "Homo sapiens", options = "names")
output <- search_images(x[1:10], options=c("pngFiles", "credit", "canonicalName"))
image_data(output, size = "64")

## Put a silhouette behind a plot
library('ggplot2')
img <- image_data("27356f15-3cf8-47e8-ab41-71c6260b2724", size = "512")[[1]]
qplot(x=Sepal.Length, y=Sepal.Width, data=iris, geom="point") + add_phylopic(img)

## Use as points in a ggplot plot
library('ggplot2')
uuid <- "c089caae-43ef-4e4e-bf26-973dd4cb65c5"
img <- image_data(uuid, size = "64")[[1]]
(p <- ggplot(mtcars, aes(drat, wt)) + geom_blank())
for(i in 1:nrow(mtcars)) p <- p + add_phylopic(img, 1, mtcars$drat[i], mtcars$wt[i], ysize = 0.3)
p
}
}
