% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{check_unit_norm}
\alias{check_unit_norm}
\title{Checking of unit-norm data}
\usage{
check_unit_norm(x, warnings = TRUE)
}
\arguments{
\item{x}{observations claimed to have unit norms. Either a matrix of size
\code{c(nx, p)} or a vector of length \code{p}.}

\item{warnings}{whether to show warnings if the normalization of
\code{x} happened.}
}
\value{
A curated version of \code{x} with unit-norm observations and
possible zeros excluded.
}
\description{
Utility for normalizing data without unit norms.
}
\examples{
check_unit_norm(c(sqrt(2), sqrt(2), 0) / 2)
check_unit_norm(1:3, warnings = FALSE)
check_unit_norm(rbind(c(0, 0, 0), c(0, 0, 1), 1:3, c(NA, 0, 1)),
                warnings = FALSE)
}
\author{
Eduardo García-Portugués, Davy Paindaveine, and Thomas Verdebout.
}
\keyword{internal}
