% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database.R
\name{set_dimension_attribute_names}
\alias{set_dimension_attribute_names}
\alias{set_dimension_attribute_names.star_database}
\title{Rename the attributes of a dimension}
\usage{
set_dimension_attribute_names(db, name, attributes)

\method{set_dimension_attribute_names}{star_database}(db, name, attributes)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{name}{A string, dimension name.}

\item{attributes}{A vector of strings, attribute names.}
}
\value{
A \code{star_database} object.
}
\description{
The dimension attribute names match those of the flat table from which they
are defined. This function allows you to change their names.
}
\examples{

db <- star_database(mrs_cause_schema, ft_num) |>
  set_dimension_attribute_names(
    name = "where",
    attributes = c(
      "Region",
      "State",
      "City"
    )
  )

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}

Other star database and constellation definition functions: 
\code{\link{constellation}()},
\code{\link{get_dimension_attribute_names}()},
\code{\link{get_fact_measure_names}()},
\code{\link{get_role_playing_dimension_names}()},
\code{\link{role_playing_dimension}()},
\code{\link{set_fact_measure_names}()},
\code{\link{snake_case}()},
\code{\link{star_database}()}
}
\concept{star database and constellation definition functions}
