% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocTree.R
\name{rocTree}
\alias{rocTree}
\title{Roc-guided survival trees}
\usage{
rocTree(formula, data, id, subset, ensemble = TRUE, splitBy = c("dCON",
  "CON"), control = list())
}
\arguments{
\item{formula}{is a formula object, with the response on the left of a '~' operator,
and the terms on the right. The response must be a survival object returned by the
'Surv' function.}

\item{data}{is an optional data frame in which to interpret the variables occurring
in the 'formula'.}

\item{id}{is an optional vector used to identify the longitudinal observations of subject's id.
The length of 'id' should be the same as the total number of observations.
If 'id' is missing, each row of `data` represents a distinct observation from a subject and
all covariates are treated as a baseline covariate.}

\item{subset}{is an optional vector specifying a subset of observations to be used in
the fitting process.}

\item{ensemble}{is an optional logical value. If \code{TRUE} (default), ensemble methods will be fitted.
Otherwise, the survival tree will be fitted.}

\item{splitBy}{is a character string specifying the splitting algorithm. The available options are 'CON' and 'dCON'
corresponding to the splitting algorithm based on the total concordance measure or the difference
in concordance measure, respectively. The default value is 'dCON'.}

\item{control}{a list of control parameters. See 'details' for important special
features of control parameters.}
}
\value{
An object of S4 class "\code{rocTree}" representig the fit, with the following components:
}
\description{
Fits a "\code{rocTree}" model.
}
\details{
The argument "control" defaults to a list with the following values:
\describe{
  \item{\code{tau}}{is the maximum follow-up time; default value is the 90th percentile of the unique observed survival times.}
  \item{\code{maxNode}}{is the maximum node number allowed to be in the tree; the default value is 500.}
  \item{\code{numFold}}{is the number of folds used in the cross-validation. When \code{numFold > 0}, the survival tree will be pruned;
when \code{numFold = 0}, the unpruned survival tree will be presented. The default value is 10.}
  \item{\code{h}}{is the smoothing parameter used in the Kernel; the default value is \code{tau / 20}.}
  \item{\code{minSplitTerm}}{is the minimum number of baseline observations in each terminal node; the default value is 15.}
  \item{\code{minSplitNode}}{is the minimum number of baseline observations in each splitable node; the default value is 30.}
  \item{\code{disc}}{is a logical vector specifying whether the covariates in \code{formula} are discrete (\code{TRUE}) or continuous (\code{FALSE}).
The length of \code{disc} should be the same as the number of covariates in \code{formula}. When not specified, the \code{rocTree()} function assumes continuous covariates for all.}
  \item{\code{K}}{is the number of time points on which the concordance measure is computed.
A less refined time grids (smaller \code{K}) generally yields faster speed but a very small \code{K} is not recommended. The default value is 20.}
}
}
\examples{
library(rocTree)
library(survival)

set.seed(1)
dat <- simu(100, 0, 1.3)

## Fitting a pruned survival tree
rocTree(Surv(Time, death) ~ z1 + z2, id = id, data = dat, ensemble = FALSE)

## Fitting a unpruned survival tree
rocTree(Surv(Time, death) ~ z1 + z2, id = id, data = dat, ensemble = FALSE,
        control = list(numFold = 0))

## Fitting the ensemble algorithm (default)
rocTree(Surv(Time, death) ~ z1 + z2, id = id, data = dat, ensemble = TRUE)

}
\references{
Sun Y. and Wang, M.C. (2018+). ROC-guided classification and survival trees. \emph{Technical report}.
}
\seealso{
See \code{\link{print.rocTree}} and \code{\link{plot.rocTree}} for printing and plotting an \code{rocTree}, respectively.
}
\keyword{rocTree}
