% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixShapley.R
\name{matrixShapley}
\alias{matrixShapley}
\title{Outlier explanation based on Shapley values for matrix-variate data}
\usage{
matrixShapley(X, mu = NULL, cov_row, cov_col, inverted = FALSE, type = "cell")
}
\arguments{
\item{X}{a 3d array of dimension \eqn{(p,q,n)}, containing \eqn{n} matrix-variate samples of \eqn{p} rows and \eqn{q} columns in each slice.}

\item{mu}{a \eqn{p \times q} matrix containing the means.}

\item{cov_row}{a \eqn{p \times p} positive-definite symmetric matrix specifying the rowwise covariance matrix}

\item{cov_col}{a \eqn{q \times q} positive-definite symmetric matrix specifying the columnwise covariance matrix}

\item{inverted}{Logical. FALSE by default.
If TRUE \code{cov_row} and \code{cov_col} are supposed to contain the inverted rowwise and columnwise covariance matrices, respectively.}

\item{type}{Character. Either "row", "col", or "cell" (default) to compute rowwise, columnwise, or cellwise Shapley values.}
}
\value{
Rowwise, columnwise, or cellwise Shapley value(s).
}
\description{
\code{matrixShapley} decomposes the squared matrix Mahalanobis distance (\code{\link{mmd}}) into additive outlyingness contributions of
the rows, columns, or cell of a matrix \insertCite{mayrhofer2023multivariate,mayrhofer2024}{robustmatrix}.
}
\examples{
n = 1000; p = 2; q = 3
mu = matrix(rep(0, p*q), nrow = p, ncol = q)
cov_row = matrix(c(5,2,2,4), nrow = p, ncol = p)
cov_col = matrix(c(3,2,1,2,3,2,1,2,3), nrow = q, ncol = q)
X <- rmatnorm(n = 1000, mu, cov_row, cov_col)
distances <- mmd(X, mu, cov_row, cov_col)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mmd}}.
}
