% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptoticEfficiency.R
\name{asymptoticVariance}
\alias{asymptoticVariance}
\alias{asymptoticEfficiency}
\alias{findTuningParameter}
\title{Compute Asymptotic Efficiencies}
\usage{
asymptoticVariance(
  psi,
  equation = c("location", "scale", "eta", "tau", "mu"),
  dimension = 1
)

asymptoticEfficiency(
  psi,
  equation = c("location", "scale", "eta", "tau", "mu"),
  dimension = 1
)

findTuningParameter(
  desiredEfficiency,
  psi,
  equation = c("location", "scale", "eta", "tau", "mu"),
  dimension = 1,
  interval = c(0.15, 50),
  ...
)
}
\arguments{
\item{psi}{object of class psi_func}

\item{equation}{equation to base computations on. \code{"location"} and
\code{"scale"} are for the univariate case. The others are for a
multivariate location and scale problem. \code{"eta"} is for the shape of
the covariance matrix, \code{"tau"} for the size of the covariance matrix
and \code{"mu"} for the location.}

\item{dimension}{dimension for the multivariate location and scale problem.}

\item{desiredEfficiency}{scalar, specifying the desired asymptotic
efficiency, needs to be between 0 and 1.}

\item{interval}{interval in which to do the root search, passed on to
\code{\link[stats]{uniroot}}.}

\item{...}{passed on to \code{\link[stats]{uniroot}}.}
}
\description{
\code{asymptoticEfficiency} computes the theoretical asymptotic efficiency
for an M-estimator for various types of equations.
}
\details{
The asymptotic efficiency is defined as the ratio between the asymptotic
variance of the maximum likelihood estimator and the asymptotic variance
of the (M-)estimator in question.

The computations are only approximate, using numerical integration in the
general case. Depending on the regularity of the psi-function, these
approximations can be quite crude.
}
\references{
Maronna, R. A., Martin, R. D., Yohai, V. J., & Salibián-Barrera,
  M. (2019). Robust statistics: theory and methods (with R). John Wiley &
  Sons., equation (2.25)

  Rousseeuw, P. J., Hampel, F. R., Ronchetti, E. M., & Stahel, W. A. (2011).
  Robust statistics: the approach based on influence functions. John Wiley &
  Sons., Section 5.3c, Paragraph 2 (Page 286)
}
