% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manageDatasets.R
\name{createDatasetsFromList}
\alias{createDatasetsFromList}
\title{Create Dataset List From List of Data Objects}
\usage{
createDatasetsFromList(
  datasetList,
  formula,
  trueBeta,
  trueSigma,
  trueTheta,
  ...
)
}
\arguments{
\item{datasetList}{list of data objects, usually of type \code{data.frame}.}

\item{formula}{formula to fit the model using \code{lmer}.}

\item{trueBeta}{scalar or vector with the true values of the fixed effects
coefficients. Can be of length one in which case it will be replicated to
the required length if needed.}

\item{trueSigma}{scalar with the true value of the error scale.}

\item{trueTheta}{scalar or vector with the true values for the variance
component coefficients, not including sigma. Can be of length one in which
case it will be replicated to the required length if needed.}

\item{...}{all additional arguments are added to the returned list.}
}
\value{
list that can be passed to \code{\link{processFit}} and to any of
  the \code{\link{fitDatasets}} functions. Only \code{generateData} is
  implemented, all the other functions return an error if called.
}
\description{
Convert a list of datasets to a dataset list similar to the ones created by
\code{\link{generateAnovaDatasets}} and
\code{\link{generateMixedEffectDatasets}}.
}
\details{
The returned list can be passed to \code{\link{processFit}} and to any of
the \code{\link{fitDatasets}} functions. Splitting and binding of datasets
using \code{\link{splitDatasets}} and \code{\link{bindDatasets}} is not
supported.
}
\examples{
  data(sleepstudy)
  sleepstudy2 <- sleepstudy
  sleepstudy2[1, "Reaction"] <- sleepstudy2[1, "Reaction"] + 10
  fm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy)
  datasets <- createDatasetsFromList(list(sleepstudy, sleepstudy2),
                                     formula = Reaction ~ Days + (Days|Subject),
                                     trueBeta = getME(fm1, "beta"),
                                     trueSigma = sigma(fm1),
                                     trueTheta = getME(fm1, "theta"))
  fitDatasets_lmer(datasets)
}
\seealso{
\code{\link{generateAnovaDatasets}} and
  \code{\link{generateMixedEffectDatasets}}
}
