% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_analysis.R
\name{cluster.analysis}
\alias{cluster.analysis}
\title{Distributed Clustering Analysis}
\usage{
cluster.analysis(environment, knn.ratios = c(0.01, 0.05, 0.1),
  nShuffleRuns = 10, shuffledKNN = 10, loadPreviousKnn = T,
  rerun = F, deleteCache = F, mem = "4GB", time = "0:15:00",
  plot = T, local = F)
}
\arguments{
\item{environment}{\code{environment} object}

\item{knn.ratios}{range of KNN parameters to scan (corresponding to different resolutions)}

\item{nShuffleRuns}{number of shuffled clustering analyses to perform per KNN threshold}

\item{shuffledKNN}{number of closest KNN shuffled analyses to include in background clustering quality computation}

\item{loadPreviousKnn}{whether to load previous analysis results}

\item{rerun}{whether to rerun the analysis rather than load from cache}

\item{deleteCache}{whether to delete cache files}

\item{mem}{HPC memory}

\item{time}{HPC time}

\item{plot}{whether to plot the clustering qualities compared to shuffled}

\item{local}{whether to run jobs locally rather than using distributed slurm system}
}
\value{
\code{environment} parameter containing clustering assignment and provisional cluster names
}
\description{
Perform clustering analysis for a range of hyperparameter (KNN Ratios) values and assess clustering quality relative to simulation analysis of shuffled data.
}
\examples{
\donttest{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
LCMV1 <- cluster.analysis(LCMV1)
}
}
