% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_plot.R
\name{weight_plot}
\alias{weight_plot}
\alias{weight_plot.default}
\alias{weight_plot.setup_weight_plot}
\title{Diagnostic plot of robust regression weights}
\usage{
weight_plot(object, ...)

\method{weight_plot}{default}(object, outcome = NULL, npoints = 1000, ...)

\method{weight_plot}{setup_weight_plot}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"\link{fit_mediation}"}
or \code{"\link{test_mediation}"} containing results from robust mediation
analysis.  Only mediation analysis objects fitted with the robust
MM-estimator are supported.}

\item{\dots}{additional arguments to be passed down.}

\item{outcome}{a character vector specifying the outcome variables of the
regressions to be included in the plot.  This must be a subset of the
hypothesized mediators and the dependent variable, or \code{NULL} (the
default) to include all regressions of the mediation model.}

\item{npoints}{the number of grid points used to evaluate and draw the
expected percentages.  The default is to use 1000 grid points.}
}
\value{
An object inheriting from class \code{"\link[ggplot2]{ggplot}"}.
}
\description{
Produce a diagnostic plot of the regression weights from robust mediation
analysis.  This plot allows to easily detect deviations from normality
assumptions such as skewness or heavy tails.
}
\details{
The horizontal axis contains different weight thresholds, and the vertical
axis displays the percentage of observations that have a weight below this
threshold.  For comparison, a reference line is drawn for the expected
percentages under normally distributed errors.  Observations with negative
and positive residuals are shown separately to make it possible to
distinguish between symmetric and asymmetric deviations from normality.

If the plot reveals more downweighted observations than expected, but
roughly the same amounts in both tails, the residual distribution is
symmetric but with heavy tails.  If the plot shows that observations in one
tail are downweighted more heavily than those in the other tail, the
residual distribution is skewed.
}
\note{
The current implementation is a slight hack of \pkg{ggplot2} and the
\pkg{grid} graphics system in order to revert the horizontal axis only in
the panels for observations with postive residuals.  It is therefore not
possible to change the horizontal axis with
\code{\link[ggplot2]{scale_x_continuous}()}.

The implementation may change in the future if the required functionality
becomes available in \pkg{ggplot2}.
}
\examples{
data("BSG2014")

# run fast and robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# create diagnostic plot of robust regression weights
weight_plot(robust_boot) +
  scale_color_manual("", values = c("black", "#00BFC4")) +
  theme(legend.position = "top")

# plot only the regression model for the hypothesized mediator
weight_plot(robust_boot, outcome = "TaskConflict") +
  scale_color_manual("", values = c("black", "#00BFC4")) +
  theme(legend.position = "top")

}
\seealso{
\code{\link{fit_mediation}()}, \code{\link{test_mediation}()},
\code{\link{setup_weight_plot}()}

\code{\link{ci_plot}()}, \code{\link{density_plot}()},
\code{\link{ellipse_plot}()}, \code{\link[=plot-methods]{plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
