% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ilr.2x2.R
\name{ilr.2x2}
\alias{ilr.2x2}
\title{ilr coordinates in 2x2 compositional tables}
\usage{
ilr.2x2(x, margin = 1, type = "independence", version = "book")
}
\arguments{
\item{x}{a 2x2 table}

\item{margin}{for 2x2 tables available for a whole set of another dimension.
For example, if 2x2 tables are available for every country.}

\item{type}{choose between \dQuote{independence} or \dQuote{interaction} table}

\item{version}{the version used in the \dQuote{paper} below or the version of
the \dQuote{book}.}
}
\value{
The ilr coordinates
}
\description{
ilr coordinates of original, independent and interaction compositional table using SBP1 and SBP2
}
\examples{
data(employment) 
ilr.2x2(employment[,,"AUT"])
ilr.2x2(employment[,,"AUT"], version = "paper")
ilr.2x2(employment, margin = 3, version = "paper")
ilr.2x2(employment[,,"AUT"], type = "interaction")
}
\references{
Facevicova, K., Hron, K., Todorov, V., Guo, D., Templ, M. (2014).
Logratio approach to statistical analysis of 2x2 compositional tables.
\emph{Journal of Applied Statistics}, 41 (5), 944--958.
}
\author{
Kamila Facevicova, Matthias Templ
}
