% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{adjust}
\alias{adjust}
\title{Adjusting for original scale}
\usage{
adjust(x)
}
\arguments{
\item{x}{object from class \sQuote{imp}}
}
\value{
The object of class \sQuote{imp} but with the adjusted imputed data.
}
\description{
Results from the model based iterative methods provides the results in
another scale (but the ratios are still the same). This function rescale the
output to the original scale.
}
\details{
It is self-explaining if you try the examples.
}
\examples{

data(expenditures)
x <- expenditures
x[1,3] <- x[2,4] <- x[3,3] <- x[3,4] <- NA
xi <- impCoda(x)
x
xi$xImp
adjust(xi)$xImp

}
\references{
Hron, K. and Templ, M. and Filzmoser, P. (2010) Imputation of
missing values for compositional data using classical and robust methods
\emph{Computational Statistics and Data Analysis}, In Press, Corrected
Proof, ISSN: 0167-9473, DOI:10.1016/j.csda.2009.11.023
}
\seealso{
\code{\link{impCoda}}
}
\author{
Matthias Templ
}
\keyword{manip}
