% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_obsspbyday.R
\name{npn_obsspbyday}
\alias{npn_obsspbyday}
\title{Get observations by day for a particular species or set of species.}
\usage{
npn_obsspbyday(speciesid = NULL, startdate = NULL, enddate = NULL, ...)
}
\arguments{
\item{speciesid}{Required. Species id numbers, from 1 to infinity, potentially,
use e.g., c(52, 53, etc.) if more than one species desired (numeric)}

\item{startdate}{start date of data period desired, see format in examples (character)}

\item{enddate}{end date of data period desired, see format in examples (character)}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
Number of observations by day, in a list
}
\description{
Get observations by day for a particular species or set of species.
}
\examples{
\dontrun{
out <- npn_obsspbyday(speciesid=357, startdate='2010-04-01', enddate='2012-01-05')
head(out[[1]])

# Lookup names
temp <- lookup_names(name='bird', type='common')
comnames <- temp[temp$species_id \%in\% c(357, 359, 1108), 'common_name']

out <- npn_obsspbyday(speciesid=c(357, 359, 1108), startdate='2010-04-01', enddate='2013-09-31')
names(out) <- comnames
library("plyr")
df <- ldply(out)
df$date <- as.Date(df$date)

library('ggplot2')
ggplot(df, aes(date, count)) +
 geom_line() +
 theme_grey(base_size=20) +
 facet_grid(.id ~.)
}
}

