# from https://www1.ncdc.noaa.gov/pub/data/cdo/documentation/NORMAL_DLY_documentation.pdf
ncdc_units_normal_dly <- list(
 "dly-cldd-base45" = list(name = "dly-cldd-base45", units = "fahrenheit", description = "Long-term averages of daily cooling degree days with base 45F"),
  "dly-cldd-base50" = list(name = "dly-cldd-base50", units = "fahrenheit", description = "Long-term averages of daily cooling degree days with base 50F"),
  "dly-cldd-base55" = list(name = "dly-cldd-base55", units = "fahrenheit", description = "Long-term averages of daily cooling degree days with base 55F"),
  "dly-cldd-base57" = list(name = "dly-cldd-base57", units = "fahrenheit", description = "Long-term averages of daily cooling degree days with base 57F"),
  "dly-cldd-base60" = list(name = "dly-cldd-base60", units = "fahrenheit", description = "Long-term averages of daily cooling degree days with base 60F"),
  "dly-cldd-base70" = list(name = "dly-cldd-base70", units = "fahrenheit", description = "Long-term averages of daily cooling degree days with base 70F"),
  "dly-cldd-base72" = list(name = "dly-cldd-base72", units = "fahrenheit", description = "Long-term averages of daily cooling degree days with base 72F"),
  "dly-cldd-normal" = list(name = "dly-cldd-normal", units = "fahrenheit", description = "Long-term averages of daily cooling degree days with base 65F"),
  "dly-dutr-normal" = list(name = "dly-dutr-normal", units = "fahrenheit", description = "Long-term averages of daily diurnal temperature range"),
  "dly-dutr-stddev" = list(name = "dly-dutr-stddev", units = "fahrenheit", description = "Long-term standard deviations of daily diurnal temperature range"),
  "dly-grdd-base40" = list(name = "dly-grdd-base40", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 40F"),
  "dly-grdd-base45" = list(name = "dly-grdd-base45", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 45F"),
  "dly-grdd-base50" = list(name = "dly-grdd-base50", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 50F"),
  "dly-grdd-base55" = list(name = "dly-grdd-base55", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 55F"),
  "dly-grdd-base57" = list(name = "dly-grdd-base57", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 57F"),
  "dly-grdd-base60" = list(name = "dly-grdd-base60", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 60F"),
  "dly-grdd-base65" = list(name = "dly-grdd-base65", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 65F"),
  "dly-grdd-base70" = list(name = "dly-grdd-base70", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 70F"),
  "dly-grdd-base72" = list(name = "dly-grdd-base72", units = "fahrenheit", description = "Long-term averages of daily growing degree days with base 72F"),
  "dly-grdd-tb4886" = list(name = "dly-grdd-tb4886", units = "fahrenheit", description = "Long-term averages of daily growing degree days with truncated bases 48F and 86F"),
  "dly-grdd-tb5086" = list(name = "dly-grdd-tb5086", units = "fahrenheit", description = "Long-term averages of daily growing degree days with truncated bases 50F and 86F"),
  "dly-htdd-base40" = list(name = "dly-htdd-base40", units = "fahrenheit", description = "Long-term averages of daily heating degree days with base 40F"),
  "dly-htdd-base45" = list(name = "dly-htdd-base45", units = "fahrenheit", description = "Long-term averages of daily heating degree days with base 45F"),
  "dly-htdd-base50" = list(name = "dly-htdd-base50", units = "fahrenheit", description = "Long-term averages of daily heating degree days with base 50F"),
  "dly-htdd-base55" = list(name = "dly-htdd-base55", units = "fahrenheit", description = "Long-term averages of daily heating degree days with base 55F"),
  "dly-htdd-base57" = list(name = "dly-htdd-base57", units = "fahrenheit", description = "Long-term averages of daily heating degree days with base 57F"),
  "dly-htdd-base60" = list(name = "dly-htdd-base60", units = "fahrenheit", description = "Long-term averages of daily heating degree days with base 60F"),
  "dly-htdd-normal" = list(name = "dly-htdd-normal", units = "fahrenheit", description = "Long-term averages of daily heating degree days with base 65F"),
  "dly-prcp-25pctl" = list(name = "dly-prcp-25pctl", units = "percent", description = "25th percentiles of daily nonzero precipitation totals for 29-day windows centered on each day of the year"),
  "dly-prcp-50pctl" = list(name = "dly-prcp-50pctl", units = "percent", description = "50th percentiles of daily nonzero precipitation totals for 29-day windows centered on each day of the year"),
  "dly-prcp-75pctl" = list(name = "dly-prcp-75pctl", units = "percent", description = "75th percentiles of daily nonzero precipitation totals for 29-day windows centered on each day of the year"),
  "dly-prcp-pctall-ge001hi" = list(name = "dly-prcp-pctall-ge001hi", units = "percent", description = "Probability of precipitation >= 0.01 inches for 29-day windows centered on each day of the year"),
  "dly-prcp-pctall-ge010hi" = list(name = "dly-prcp-pctall-ge010hi", units = "percent", description = "Probability of precipitation >= 0.10 inches for 29-day windows centered on each day of the year"),
  "dly-prcp-pctall-ge050hi" = list(name = "dly-prcp-pctall-ge050hi", units = "percent", description = "Probability of precipitation >= 0.50 inches for 29-day windows centered on each day of the year"),
  "dly-prcp-pctall-ge100hi" = list(name = "dly-prcp-pctall-ge100hi", units = "percent", description = "Probability of precipitation >= 1.00 inches for 29-day windows centered on each day of the year"),
  "dly-snow-25pctl" = list(name = "dly-snow-25pctl", units = "", description = "25th percentiles of daily nonzero snowfall totals for 29-day windows centered on each day of the year"),
  "dly-snow-50pctl" = list(name = "dly-snow-50pctl", units = "", description = "50th percentiles of daily nonzero snowfall totals for 29-day windows centered on each day of the year"),
  "dly-snow-75pctl" = list(name = "dly-snow-75pctl", units = "", description = "75th percentiles of daily nonzero snowfall totals for 29-day windows centered on each day of the year"),
  "dly-snow-pctall-ge001ti" = list(name = "dly-snow-pctall-ge001ti", units = "percent", description = "Probability of snowfall >= 0.1 inches for 29-day windows centered on each day of the year"),
  "dly-snow-pctall-ge010ti" = list(name = "dly-snow-pctall-ge010ti", units = "percent", description = "Probability of snowfall >= 1.0 inches for 29-day windows centered on each day of the year"),
  "dly-snow-pctall-ge030ti" = list(name = "dly-snow-pctall-ge030ti", units = "percent", description = "Probability of snowfall >= 3.0 inches for 29-day windows centered on each day of the year"),
  "dly-snow-pctall-ge050ti" = list(name = "dly-snow-pctall-ge050ti", units = "percent", description = "Probability of snowfall >= 5.0 inches for 29-day windows centered on each day of the year"),
  "dly-snow-pctall-ge100ti" = list(name = "dly-snow-pctall-ge100ti", units = "percent", description = "Probability of snowfall >= 10 inches for 29-day windows centered on each day of the year"),
  "dly-snwd-25pctl" = list(name = "dly-snwd-25pctl", units = "", description = "25th percentiles of daily nonzero snow depth for 29-day windows centered on each day of the year"),
  "dly-snwd-50pctl" = list(name = "dly-snwd-50pctl", units = "", description = "50th percentiles of daily nonzero snow depth for 29-day windows centered on each day of the year"),
  "dly-snwd-75pctl" = list(name = "dly-snwd-75pctl", units = "", description = "75th percentiles of daily nonzero snow depth for 29-day windows centered on each day of the year"),
  "dly-snwd-pctall-ge001wi" = list(name = "dly-snwd-pctall-ge001wi", units = "percent", description = "Probability of snow depth >= 1 inch for 29-day windows centered on each day of the year"),
  "dly-snwd-pctall-ge003wi" = list(name = "dly-snwd-pctall-ge003wi", units = "percent", description = "Probability of snow depth >= 3 inches for 29-day windows centered on each day of the year"),
  "dly-snwd-pctall-ge005wi" = list(name = "dly-snwd-pctall-ge005wi", units = "percent", description = "Probability of snow depth >= 5 inches for 29-day windows centered on each day of the year"),
  "dly-snwd-pctall-ge010wi" = list(name = "dly-snwd-pctall-ge010wi", units = "percent", description = "Probability of snow depth >= 10 inches for 29-day windows centered on each day of the year"),
  "dly-tavg-normal" = list(name = "dly-tavg-normal", units = "fahrenheit_tenths", description = "Long-term averages of daily average temperature"),
  "dly-tavg-stddev" = list(name = "dly-tavg-stddev", units = "fahrenheit_tenths", description = "Long-term standard deviations of daily average temperature"),
  "dly-tmax-normal" = list(name = "dly-tmax-normal", units = "fahrenheit_tenths", description = "Long-term averages of daily maximum temperature"),
  "dly-tmax-stddev" = list(name = "dly-tmax-stddev", units = "fahrenheit_tenths", description = "Long-term standard deviations of daily maximum temperature"),
  "dly-tmin-normal" = list(name = "dly-tmin-normal", units = "fahrenheit_tenths", description = "Long-term averages of daily minimum temperature"),
  "dly-tmin-stddev" = list(name = "dly-tmin-stddev", units = "fahrenheit_tenths", description = "Long-term standard deviations of daily minimum temperature"),
  "mtd-prcp-normal" = list(name = "mtd-prcp-normal", units = "mm_tenths", description = "Long-term average month-to-date liquid precipitation amount"),
  "mtd-snow-normal" = list(name = "mtd-snow-normal", units = "mm", description = "Long-term average month-to-date snowfall amount"),
  "ytd-prcp-normal" = list(name = "ytd-prcp-normal", units = "mm_tenths", description = "Long-term average year-to-date liquid precipitation amount"),
  "ytd-snow-normal" = list(name = "ytd-snow-normal", units = "mm", description = "Long-term average year-to-date snowfall amount")
)
