% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tornadoes.R
\name{tornadoes}
\alias{tornadoes}
\title{Get NOAA tornado data.}
\usage{
tornadoes(overwrite = TRUE, ...)
}
\arguments{
\item{overwrite}{(logical) To overwrite the path to store files in or not,
Default: \code{TRUE}}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}
(optional)}
}
\value{
A Spatial object is returned of class SpatialLinesDataFrame.
}
\description{
Get NOAA tornado data.
}
\section{File storage}{

We use \pkg{rappdirs} to store files, see
\code{\link[rappdirs]{user_cache_dir}} for how
we determine the directory on your machine to save files to, and run
\code{rappdirs::user_cache_dir("rnoaa/tornadoes")} to get that directory.
}

\examples{
\dontrun{
shp <- tornadoes()
library('sp')
plot(shp) # may take 10 sec or so to render
}
}
\references{
\url{http://www.spc.noaa.gov/gis/svrgis/}
}
