% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictr.R
\name{predictr}
\alias{predictr}
\title{Recurrent Neural Network}
\usage{
predictr(model, X, hidden = FALSE, real_output = T, ...)
}
\arguments{
\item{model}{output of the trainr function}

\item{X}{array of input values, dim 1: samples, dim 2: time, dim 3: variables (could be 1 or more, if a matrix, will be coerce to array)}

\item{hidden}{should the function output the hidden units states}

\item{real_output}{option used when the function in called inside trainr, do not drop factor for 2 dimension array output and other actions. Let it to TRUE, the default, to let the function take care of the data.}

\item{...}{arguments to pass on to sigmoid function}
}
\value{
array or matrix of predicted values
}
\description{
predict the output of a RNN model
}
\examples{
\dontrun{ 
# create training numbers
X1 = sample(0:127, 10000, replace=TRUE)
X2 = sample(0:127, 10000, replace=TRUE)

# create training response numbers
Y <- X1 + X2

# convert to binary
X1 <- int2bin(X1)
X2 <- int2bin(X2)
Y  <- int2bin(Y)

# Create 3d array: dim 1: samples; dim 2: time; dim 3: variables.
X <- array( c(X1,X2), dim=c(dim(X1),2) )

# train the model
model <- trainr(Y=Y[,dim(Y)[2]:1],
                X=X[,dim(X)[2]:1,],
                learningrate   =  1,
                hidden_dim     = 16 )
             
# create test inputs
A1 = int2bin( sample(0:127, 7000, replace=TRUE) )
A2 = int2bin( sample(0:127, 7000, replace=TRUE) )

# create 3d array: dim 1: samples; dim 2: time; dim 3: variables
A <- array( c(A1,A2), dim=c(dim(A1),2) )
    
# predict
B  <- predictr(model,
               A[,dim(A)[2]:1,]     )
B = B[,dim(B)[2]:1]
# convert back to integers
A1 <- bin2int(A1)
A2 <- bin2int(A2)
B  <- bin2int(B)
 
# inspect the differences              
table( B-(A1+A2) )

# plot the difference
hist(  B-(A1+A2) )
}

}
