% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldrnaCrosslinkMethodsAndHelpers.R
\docType{methods}
\name{plotComparisonArc}
\alias{plotComparisonArc}
\alias{plotComparisonArc,rnaCrosslinkDataSet-method}
\title{plotComparisonArc}
\usage{
plotComparisonArc(foldedCds, s1 = "s1", s2 = "s2", n1 = 1, n2 = 2)
}
\arguments{
\item{foldedCds}{\code{rnaCrosslinkDataSet} after running foldrnaCrosslink}

\item{s1}{sample of structure 1}

\item{s2}{sample of structure 2}

\item{n1}{number of structure from first sample}

\item{n2}{number of structure from first sample}
}
\value{
an ark diagram of the two strcutures
}
\description{
This method plots two structures chosen from the
plotEnsemblePCA method
}
\examples{
\dontrun{
cds = makeExamplernaCrosslinkDataSet()
clusteredCds = clusterrnaCrosslink(cds = cds,
                               cores = 3,
                               stepCount = 2,
                               clusterCutoff = 1)


trimmedClusters = trimClusters(clusteredCds = clusteredCds,trimFactor = 1, clusterCutoff = 1)



fasta = paste(c(rep('A',25),
                rep('T',25),
                rep('A',10),
                rep('T',23)),collapse = "")

header = '>transcript1'


fastaFile = tempfile()
writeLines(paste(header,fasta,sep = "\n"),con = fastaFile)


rnaRefs = list()
rnaRefs[[rnas(cds)]] = read.fasta(fastaFile)
rnaRefs



foldedCds = foldrnaCrosslink(trimmedClusters,
                         rnaRefs = rnaRefs,
                         start = 1,
                         end = 83,
                         shape = 0,
                         ensembl = 5,
                         constraintNumber  = 1,
                         evCutoff = 1)


plotComparisonArc(foldedCds,"s1","s1",1,3)
}
}
