% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rmc.R
\name{plot.rmc}
\alias{plot.rmc}
\title{Plot the repeated measures correlation coefficient.}
\usage{
\method{plot}{rmc}(x, dataset, overall = T, palette = NULL, xlab = NULL,
  ylab = NULL, overall.col = "gray60", overall.lwd = 3, overall.lty = 2,
  ...)
}
\arguments{
\item{x}{an object of class "rmc" generated from the \code{\link{rmcorr}} function.}

\item{dataset}{the data frame containing the variables.}

\item{overall}{logical: if TRUE, plots the regression line between measure1 and
measure2, ignoring the participant variable.}

\item{palette}{the palette to be used. Defaults to the RColorBrewer "Paired" palette}

\item{xlab}{label for the x axis, defaults to the variable name for measure1.}

\item{ylab}{label for the y axis, defaults to the variable name for measure2.}

\item{overall.col}{the color of the overall regression line}

\item{overall.lwd}{the line thickness of the overall regression line}

\item{overall.lty}{the line type of the overall regression line}

\item{...}{additional arguments to \code{\link[graphics]{plot}}.}
}
\description{
\code{plot.rmc}  produces a scatterplot of \code{measure1} on the x-axis and 
\code{measure2} on the y-axis, with a different color used for each subject.
Parallel lines are fitted to each subject's data.
}
\examples{
## Bland Altman 1995 data
my.rmc <- rmcorr(participant = Subject, measure1 = PacO2, measure2 = pH, dataset = bland1995)
plot(my.rmc, bland1995, overall = TRUE)

## Raz et al. 2005 data
my.rmc <- rmcorr(participant = Participant, measure1 = Age, measure2 = Volume, dataset = raz2005)
library(RColorBrewer)
blueset <- brewer.pal(8, 'Blues')
pal <- colorRampPalette(blueset)
plot(my.rmc, raz2005, overall = TRUE, palette = pal, overall.col = 'black') 

## Gilden et al. 2010 data
my.rmc <- rmcorr(participant = sub, measure1 = rt, measure2 = acc, dataset = gilden2010)
plot(my.rmc, gilden2010, overall = FALSE, lty = 2, xlab = "Reaction Time", ylab = "Accuracy")
}
\seealso{
\code{\link{rmcorr}}
}

