/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;
import weka.estimators.NormalEstimator;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class NaiveBayes
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 5995231201785697655L;
    protected Estimator[][] m_Distributions;
    protected Estimator m_ClassDistribution;
    protected boolean m_UseKernelEstimator = false;
    protected boolean m_UseDiscretization = false;
    protected int m_NumClasses;
    protected Instances m_Instances;
    protected static final double DEFAULT_NUM_PRECISION = 0.01;
    protected Discretize m_Disc = null;
    protected boolean m_displayModelInOldFormat = false;

    public String globalInfo() {
        return "Class for a Naive Bayes classifier using estimator classes. Numeric estimator precision values are chosen based on analysis of the  training data. For this reason, the classifier is not an UpdateableClassifier (which in typical usage are initialized with zero training instances) -- if you need the UpdateableClassifier functionality, use the NaiveBayesUpdateable classifier. The NaiveBayesUpdateable classifier will  use a default precision of 0.1 for numeric attributes when buildClassifier is called with zero training instances.\n\nFor more information on Naive Bayes classifiers, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "George H. John and Pat Langley");
        result.setValue(TechnicalInformation.Field.TITLE, "Estimating Continuous Distributions in Bayesian Classifiers");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Eleventh Conference on Uncertainty in Artificial Intelligence");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.PAGES, "338-345");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        result.setValue(TechnicalInformation.Field.ADDRESS, "San Mateo");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_NumClasses = instances.numClasses();
        this.m_Instances = new Instances(instances);
        if (this.m_UseDiscretization) {
            this.m_Disc = new Discretize();
            this.m_Disc.setInputFormat(this.m_Instances);
            this.m_Instances = Filter.useFilter(this.m_Instances, this.m_Disc);
        } else {
            this.m_Disc = null;
        }
        this.m_Distributions = new Estimator[this.m_Instances.numAttributes() - 1][this.m_Instances.numClasses()];
        this.m_ClassDistribution = new DiscreteEstimator(this.m_Instances.numClasses(), true);
        int attIndex = 0;
        Enumeration enu = this.m_Instances.enumerateAttributes();
        while (enu.hasMoreElements()) {
            Attribute attribute = (Attribute)enu.nextElement();
            double numPrecision = 0.01;
            if (attribute.type() == 0) {
                this.m_Instances.sort(attribute);
                if (this.m_Instances.numInstances() > 0 && !this.m_Instances.instance(0).isMissing(attribute)) {
                    double lastVal = this.m_Instances.instance(0).value(attribute);
                    double deltaSum = 0.0;
                    int distinct = 0;
                    int i = 1;
                    while (i < this.m_Instances.numInstances()) {
                        Instance currentInst = this.m_Instances.instance(i);
                        if (currentInst.isMissing(attribute)) break;
                        double currentVal = currentInst.value(attribute);
                        if (currentVal != lastVal) {
                            deltaSum += currentVal - lastVal;
                            lastVal = currentVal;
                            ++distinct;
                        }
                        ++i;
                    }
                    if (distinct > 0) {
                        numPrecision = deltaSum / (double)distinct;
                    }
                }
            }
            int j = 0;
            while (j < this.m_Instances.numClasses()) {
                switch (attribute.type()) {
                    case 0: {
                        if (this.m_UseKernelEstimator) {
                            this.m_Distributions[attIndex][j] = new KernelEstimator(numPrecision);
                            break;
                        }
                        this.m_Distributions[attIndex][j] = new NormalEstimator(numPrecision);
                        break;
                    }
                    case 1: {
                        this.m_Distributions[attIndex][j] = new DiscreteEstimator(attribute.numValues(), true);
                        break;
                    }
                    default: {
                        throw new Exception("Attribute type unknown to NaiveBayes");
                    }
                }
                ++j;
            }
            ++attIndex;
        }
        Enumeration enumInsts = this.m_Instances.enumerateInstances();
        while (enumInsts.hasMoreElements()) {
            Instance instance = (Instance)enumInsts.nextElement();
            this.updateClassifier(instance);
        }
        this.m_Instances = new Instances(this.m_Instances, 0);
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            Enumeration enumAtts = this.m_Instances.enumerateAttributes();
            int attIndex = 0;
            while (enumAtts.hasMoreElements()) {
                Attribute attribute = (Attribute)enumAtts.nextElement();
                if (!instance.isMissing(attribute)) {
                    this.m_Distributions[attIndex][(int)instance.classValue()].addValue(instance.value(attribute), instance.weight());
                }
                ++attIndex;
            }
            this.m_ClassDistribution.addValue(instance.classValue(), instance.weight());
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_UseDiscretization) {
            this.m_Disc.input(instance);
            instance = this.m_Disc.output();
        }
        double[] probs = new double[this.m_NumClasses];
        int j = 0;
        while (j < this.m_NumClasses) {
            probs[j] = this.m_ClassDistribution.getProbability(j);
            ++j;
        }
        Enumeration enumAtts = instance.enumerateAttributes();
        int attIndex = 0;
        while (enumAtts.hasMoreElements()) {
            Attribute attribute = (Attribute)enumAtts.nextElement();
            if (!instance.isMissing(attribute)) {
                double max = 0.0;
                int j2 = 0;
                while (j2 < this.m_NumClasses) {
                    double temp = Math.max(1.0E-75, Math.pow(this.m_Distributions[attIndex][j2].getProbability(instance.value(attribute)), this.m_Instances.attribute(attIndex).weight()));
                    int n = j2;
                    probs[n] = probs[n] * temp;
                    if (probs[j2] > max) {
                        max = probs[j2];
                    }
                    if (Double.isNaN(probs[j2])) {
                        throw new Exception("NaN returned from estimator for attribute " + attribute.name() + ":\n" + this.m_Distributions[attIndex][j2].toString());
                    }
                    ++j2;
                }
                if (max > 0.0 && max < 1.0E-75) {
                    j2 = 0;
                    while (j2 < this.m_NumClasses) {
                        int n = j2++;
                        probs[n] = probs[n] * 1.0E75;
                    }
                }
            }
            ++attIndex;
        }
        Utils.normalize(probs);
        return probs;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tUse kernel density estimator rather than normal\n\tdistribution for numeric attributes", "K", 0, "-K"));
        newVector.addElement(new Option("\tUse supervised discretization to process numeric attributes\n", "D", 0, "-D"));
        newVector.addElement(new Option("\tDisplay model in old format (good when there are many classes)\n", "O", 0, "-O"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        boolean k = Utils.getFlag('K', options);
        boolean d = Utils.getFlag('D', options);
        if (k && d) {
            throw new IllegalArgumentException("Can't use both kernel density estimation and discretization!");
        }
        this.setUseSupervisedDiscretization(d);
        this.setUseKernelEstimator(k);
        this.setDisplayModelInOldFormat(Utils.getFlag('O', options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[3];
        int current = 0;
        if (this.m_UseKernelEstimator) {
            options[current++] = "-K";
        }
        if (this.m_UseDiscretization) {
            options[current++] = "-D";
        }
        if (this.m_displayModelInOldFormat) {
            options[current++] = "-O";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        if (this.m_displayModelInOldFormat) {
            return this.toStringOriginal();
        }
        StringBuffer temp = new StringBuffer();
        temp.append("Naive Bayes Classifier");
        if (this.m_Instances == null) {
            temp.append(": No model built yet.");
        } else {
            String priorP;
            int maxWidth = 0;
            int maxAttWidth = 0;
            boolean containsKernel = false;
            int i = 0;
            while (i < this.m_Instances.numClasses()) {
                if (this.m_Instances.classAttribute().value(i).length() > maxWidth) {
                    maxWidth = this.m_Instances.classAttribute().value(i).length();
                }
                ++i;
            }
            i = 0;
            while (i < this.m_Instances.numAttributes()) {
                if (i != this.m_Instances.classIndex()) {
                    Attribute a = this.m_Instances.attribute(i);
                    if (a.name().length() > maxAttWidth) {
                        maxAttWidth = this.m_Instances.attribute(i).name().length();
                    }
                    if (a.isNominal()) {
                        int j = 0;
                        while (j < a.numValues()) {
                            String val = String.valueOf(a.value(j)) + "  ";
                            if (val.length() > maxAttWidth) {
                                maxAttWidth = val.length();
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.m_Distributions.length) {
                int j = 0;
                while (j < this.m_Instances.numClasses()) {
                    if (this.m_Distributions[i][0] instanceof NormalEstimator) {
                        double precision;
                        double width;
                        NormalEstimator n = (NormalEstimator)this.m_Distributions[i][j];
                        double mean = Math.log(Math.abs(n.getMean())) / Math.log(10.0);
                        double d = width = mean > (precision = Math.log(Math.abs(n.getPrecision())) / Math.log(10.0)) ? mean : precision;
                        if (width < 0.0) {
                            width = 1.0;
                        }
                        if ((int)(width += 6.0) > maxWidth) {
                            maxWidth = (int)width;
                        }
                    } else if (this.m_Distributions[i][0] instanceof KernelEstimator) {
                        containsKernel = true;
                        KernelEstimator ke = (KernelEstimator)this.m_Distributions[i][j];
                        int numK = ke.getNumKernels();
                        String temps = "K" + numK + ": mean (weight)";
                        if (maxAttWidth < temps.length()) {
                            maxAttWidth = temps.length();
                        }
                        if (ke.getNumKernels() > 0) {
                            double[] means = ke.getMeans();
                            double[] weights = ke.getWeights();
                            int k = 0;
                            while (k < ke.getNumKernels()) {
                                String m = Utils.doubleToString(means[k], maxWidth, 4).trim();
                                if (maxWidth < (m = String.valueOf(m) + " (" + Utils.doubleToString(weights[k], maxWidth, 1).trim() + ")").length()) {
                                    maxWidth = m.length();
                                }
                                ++k;
                            }
                        }
                    } else if (this.m_Distributions[i][0] instanceof DiscreteEstimator) {
                        DiscreteEstimator d = (DiscreteEstimator)this.m_Distributions[i][j];
                        int k = 0;
                        while (k < d.getNumSymbols()) {
                            String size = "" + d.getCount(k);
                            if (size.length() > maxWidth) {
                                maxWidth = size.length();
                            }
                            ++k;
                        }
                        int sum = ("" + d.getSumOfCounts()).length();
                        if (sum > maxWidth) {
                            maxWidth = sum;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.m_Instances.numClasses()) {
                String cSize = this.m_Instances.classAttribute().value(i);
                if (cSize.length() > maxWidth) {
                    maxWidth = cSize.length();
                }
                ++i;
            }
            i = 0;
            while (i < this.m_Instances.numClasses()) {
                priorP = Utils.doubleToString(((DiscreteEstimator)this.m_ClassDistribution).getProbability(i), maxWidth, 2).trim();
                if ((priorP = "(" + priorP + ")").length() > maxWidth) {
                    maxWidth = priorP.length();
                }
                ++i;
            }
            if (maxAttWidth < "Attribute".length()) {
                maxAttWidth = "Attribute".length();
            }
            if (maxAttWidth < "  weight sum".length()) {
                maxAttWidth = "  weight sum".length();
            }
            if (containsKernel && maxAttWidth < "  [precision]".length()) {
                maxAttWidth = "  [precision]".length();
            }
            temp.append("\n\n");
            temp.append(this.pad("Class", " ", (maxAttWidth += 2) + maxWidth + 1 - "Class".length(), true));
            temp.append("\n");
            temp.append(this.pad("Attribute", " ", maxAttWidth - "Attribute".length(), false));
            i = 0;
            while (i < this.m_Instances.numClasses()) {
                String classL = this.m_Instances.classAttribute().value(i);
                temp.append(this.pad(classL, " ", maxWidth + 1 - classL.length(), true));
                ++i;
            }
            temp.append("\n");
            temp.append(this.pad("", " ", maxAttWidth, true));
            i = 0;
            while (i < this.m_Instances.numClasses()) {
                priorP = Utils.doubleToString(((DiscreteEstimator)this.m_ClassDistribution).getProbability(i), maxWidth, 2).trim();
                priorP = "(" + priorP + ")";
                temp.append(this.pad(priorP, " ", maxWidth + 1 - priorP.length(), true));
                ++i;
            }
            temp.append("\n");
            temp.append(this.pad("", "=", maxAttWidth + maxWidth * this.m_Instances.numClasses() + this.m_Instances.numClasses() + 1, true));
            temp.append("\n");
            int counter = 0;
            int i2 = 0;
            while (i2 < this.m_Instances.numAttributes()) {
                if (i2 != this.m_Instances.classIndex()) {
                    String stdDevL;
                    String attName = this.m_Instances.attribute(i2).name();
                    temp.append(String.valueOf(attName) + "\n");
                    if (this.m_Distributions[counter][0] instanceof NormalEstimator) {
                        String meanL = "  mean";
                        temp.append(this.pad(meanL, " ", maxAttWidth + 1 - meanL.length(), false));
                        int j = 0;
                        while (j < this.m_Instances.numClasses()) {
                            NormalEstimator n = (NormalEstimator)this.m_Distributions[counter][j];
                            String mean = Utils.doubleToString(n.getMean(), maxWidth, 4).trim();
                            temp.append(this.pad(mean, " ", maxWidth + 1 - mean.length(), true));
                            ++j;
                        }
                        temp.append("\n");
                        stdDevL = "  std. dev.";
                        temp.append(this.pad(stdDevL, " ", maxAttWidth + 1 - stdDevL.length(), false));
                        int j2 = 0;
                        while (j2 < this.m_Instances.numClasses()) {
                            NormalEstimator n = (NormalEstimator)this.m_Distributions[counter][j2];
                            String stdDev = Utils.doubleToString(n.getStdDev(), maxWidth, 4).trim();
                            temp.append(this.pad(stdDev, " ", maxWidth + 1 - stdDev.length(), true));
                            ++j2;
                        }
                        temp.append("\n");
                        String weightL = "  weight sum";
                        temp.append(this.pad(weightL, " ", maxAttWidth + 1 - weightL.length(), false));
                        int j3 = 0;
                        while (j3 < this.m_Instances.numClasses()) {
                            NormalEstimator n = (NormalEstimator)this.m_Distributions[counter][j3];
                            String weight = Utils.doubleToString(n.getSumOfWeights(), maxWidth, 4).trim();
                            temp.append(this.pad(weight, " ", maxWidth + 1 - weight.length(), true));
                            ++j3;
                        }
                        temp.append("\n");
                        String precisionL = "  precision";
                        temp.append(this.pad(precisionL, " ", maxAttWidth + 1 - precisionL.length(), false));
                        int j4 = 0;
                        while (j4 < this.m_Instances.numClasses()) {
                            NormalEstimator n = (NormalEstimator)this.m_Distributions[counter][j4];
                            String precision = Utils.doubleToString(n.getPrecision(), maxWidth, 4).trim();
                            temp.append(this.pad(precision, " ", maxWidth + 1 - precision.length(), true));
                            ++j4;
                        }
                        temp.append("\n\n");
                    } else if (this.m_Distributions[counter][0] instanceof DiscreteEstimator) {
                        Attribute a = this.m_Instances.attribute(i2);
                        int j = 0;
                        while (j < a.numValues()) {
                            String val = "  " + a.value(j);
                            temp.append(this.pad(val, " ", maxAttWidth + 1 - val.length(), false));
                            int k = 0;
                            while (k < this.m_Instances.numClasses()) {
                                DiscreteEstimator d = (DiscreteEstimator)this.m_Distributions[counter][k];
                                String count = "" + d.getCount(j);
                                temp.append(this.pad(count, " ", maxWidth + 1 - count.length(), true));
                                ++k;
                            }
                            temp.append("\n");
                            ++j;
                        }
                        String total = "  [total]";
                        temp.append(this.pad(total, " ", maxAttWidth + 1 - total.length(), false));
                        int k = 0;
                        while (k < this.m_Instances.numClasses()) {
                            DiscreteEstimator d = (DiscreteEstimator)this.m_Distributions[counter][k];
                            String count = "" + d.getSumOfCounts();
                            temp.append(this.pad(count, " ", maxWidth + 1 - count.length(), true));
                            ++k;
                        }
                        temp.append("\n\n");
                    } else if (this.m_Distributions[counter][0] instanceof KernelEstimator) {
                        String kL = "  [# kernels]";
                        temp.append(this.pad(kL, " ", maxAttWidth + 1 - kL.length(), false));
                        int k = 0;
                        while (k < this.m_Instances.numClasses()) {
                            KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k];
                            String nk = "" + ke.getNumKernels();
                            temp.append(this.pad(nk, " ", maxWidth + 1 - nk.length(), true));
                            ++k;
                        }
                        temp.append("\n");
                        stdDevL = "  [std. dev]";
                        temp.append(this.pad(stdDevL, " ", maxAttWidth + 1 - stdDevL.length(), false));
                        int k2 = 0;
                        while (k2 < this.m_Instances.numClasses()) {
                            KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k2];
                            String stdD = Utils.doubleToString(ke.getStdDev(), maxWidth, 4).trim();
                            temp.append(this.pad(stdD, " ", maxWidth + 1 - stdD.length(), true));
                            ++k2;
                        }
                        temp.append("\n");
                        String precL = "  [precision]";
                        temp.append(this.pad(precL, " ", maxAttWidth + 1 - precL.length(), false));
                        int k3 = 0;
                        while (k3 < this.m_Instances.numClasses()) {
                            KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k3];
                            String prec = Utils.doubleToString(ke.getPrecision(), maxWidth, 4).trim();
                            temp.append(this.pad(prec, " ", maxWidth + 1 - prec.length(), true));
                            ++k3;
                        }
                        temp.append("\n");
                        int maxK = 0;
                        int k4 = 0;
                        while (k4 < this.m_Instances.numClasses()) {
                            KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k4];
                            if (ke.getNumKernels() > maxK) {
                                maxK = ke.getNumKernels();
                            }
                            ++k4;
                        }
                        int j = 0;
                        while (j < maxK) {
                            String meanL = "  K" + (j + 1) + ": mean (weight)";
                            temp.append(this.pad(meanL, " ", maxAttWidth + 1 - meanL.length(), false));
                            int k5 = 0;
                            while (k5 < this.m_Instances.numClasses()) {
                                KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k5];
                                double[] means = ke.getMeans();
                                double[] weights = ke.getWeights();
                                String m = "--";
                                if (ke.getNumKernels() == 0) {
                                    m = "0";
                                } else if (j < ke.getNumKernels()) {
                                    m = Utils.doubleToString(means[j], maxWidth, 4).trim();
                                    m = String.valueOf(m) + " (" + Utils.doubleToString(weights[j], maxWidth, 1).trim() + ")";
                                }
                                temp.append(this.pad(m, " ", maxWidth + 1 - m.length(), true));
                                ++k5;
                            }
                            temp.append("\n");
                            ++j;
                        }
                        temp.append("\n");
                    }
                    ++counter;
                }
                ++i2;
            }
        }
        return temp.toString();
    }

    protected String toStringOriginal() {
        StringBuffer text = new StringBuffer();
        text.append("Naive Bayes Classifier");
        if (this.m_Instances == null) {
            text.append(": No model built yet.");
        } else {
            try {
                int i = 0;
                while (i < this.m_Distributions[0].length) {
                    text.append("\n\nClass " + this.m_Instances.classAttribute().value(i) + ": Prior probability = " + Utils.doubleToString(this.m_ClassDistribution.getProbability(i), 4, 2) + "\n\n");
                    Enumeration enumAtts = this.m_Instances.enumerateAttributes();
                    int attIndex = 0;
                    while (enumAtts.hasMoreElements()) {
                        Attribute attribute = (Attribute)enumAtts.nextElement();
                        if (attribute.weight() > 0.0) {
                            text.append(String.valueOf(attribute.name()) + ":  " + this.m_Distributions[attIndex][i]);
                        }
                        ++attIndex;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                text.append(ex.getMessage());
            }
        }
        return text.toString();
    }

    private String pad(String source, String padChar, int length, boolean leftPad) {
        StringBuffer temp = new StringBuffer();
        if (leftPad) {
            int i = 0;
            while (i < length) {
                temp.append(padChar);
                ++i;
            }
            temp.append(source);
        } else {
            temp.append(source);
            int i = 0;
            while (i < length) {
                temp.append(padChar);
                ++i;
            }
        }
        return temp.toString();
    }

    public String useKernelEstimatorTipText() {
        return "Use a kernel estimator for numeric attributes rather than a normal distribution.";
    }

    public boolean getUseKernelEstimator() {
        return this.m_UseKernelEstimator;
    }

    public void setUseKernelEstimator(boolean v) {
        this.m_UseKernelEstimator = v;
        if (v) {
            this.setUseSupervisedDiscretization(false);
        }
    }

    public String useSupervisedDiscretizationTipText() {
        return "Use supervised discretization to convert numeric attributes to nominal ones.";
    }

    public boolean getUseSupervisedDiscretization() {
        return this.m_UseDiscretization;
    }

    public void setUseSupervisedDiscretization(boolean newblah) {
        this.m_UseDiscretization = newblah;
        if (newblah) {
            this.setUseKernelEstimator(false);
        }
    }

    public String displayModelInOldFormatTipText() {
        return "Use old format for model output. The old format is better when there are many class values. The new format is better when there are fewer classes and many attributes.";
    }

    public void setDisplayModelInOldFormat(boolean d) {
        this.m_displayModelInOldFormat = d;
    }

    public boolean getDisplayModelInOldFormat() {
        return this.m_displayModelInOldFormat;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5516 $");
    }

    public static void main(String[] argv) {
        NaiveBayes.runClassifier(new NaiveBayes(), argv);
    }
}

