/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ft;

import weka.classifiers.functions.SimpleLinearRegression;
import weka.classifiers.trees.ft.FTtree;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class FTInnerNode
extends FTtree {
    private static final long serialVersionUID = -1125334488640233181L;

    public FTInnerNode(boolean errorOnProbabilities, int numBoostingIterations, int minNumInstances, double weightTrimBeta, boolean useAIC) {
        this.m_errorOnProbabilities = errorOnProbabilities;
        this.m_fixedNumIterations = numBoostingIterations;
        this.m_minNumInstances = minNumInstances;
        this.m_maxIterations = 200;
        this.setWeightTrimBeta(weightTrimBeta);
        this.setUseAIC(useAIC);
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        data = this.insertNewAttr(data);
        this.buildTree(data, null, data.numInstances(), 0.0);
    }

    @Override
    public void buildTree(Instances data, SimpleLinearRegression[][] higherRegressions, double totalInstanceWeight, double higherNumParameters) throws Exception {
        this.m_totalInstanceWeight = totalInstanceWeight;
        this.m_train = new Instances(data);
        this.m_train = this.removeExtAttributes(this.m_train);
        this.m_isLeaf = true;
        this.m_sons = null;
        this.m_numInstances = this.m_train.numInstances();
        this.m_numClasses = this.m_train.numClasses();
        this.m_numericData = this.getNumericData(this.m_train);
        this.m_numericDataHeader = new Instances(this.m_numericData, 0);
        this.m_regressions = this.initRegressions();
        this.m_numRegressions = 0;
        this.m_higherRegressions = higherRegressions != null ? higherRegressions : new SimpleLinearRegression[this.m_numClasses][0];
        this.m_numHigherRegressions = this.m_higherRegressions[0].length;
        this.m_numParameters = higherNumParameters;
        if (this.m_numInstances >= m_numFoldsBoosting) {
            if (this.m_fixedNumIterations > 0) {
                this.performBoosting(this.m_fixedNumIterations);
            } else if (this.getUseAIC()) {
                this.performBoostingInfCriterion();
            } else {
                this.performBoostingCV();
            }
        }
        this.m_numParameters += (double)this.m_numRegressions;
        this.m_regressions = this.selectRegressions(this.m_regressions);
        double[][] FsConst = this.getFs(this.m_numericData);
        int j = 0;
        while (j < data.numInstances()) {
            double[] probsConst = this.probs(FsConst[j]);
            if (data.instance(j).classValue() != (double)this.getConstError(probsConst)) {
                this.m_constError += 1.0;
            }
            int i = 0;
            while (i < data.classAttribute().numValues()) {
                data.instance(j).setValue(i, probsConst[i]);
                ++i;
            }
            ++j;
        }
        this.m_modelSelection = new C45ModelSelection(this.m_minNumInstances, data);
        this.m_localModel = this.m_modelSelection.selectModel(data);
        boolean grow = this.m_numInstances > this.m_minNumInstances ? this.m_localModel.numSubsets() > 1 : false;
        this.m_hasConstr = false;
        this.m_train = data;
        if (grow) {
            this.m_isLeaf = false;
            Instances[] localInstances = this.m_localModel.split(data);
            if (((C45Split)this.m_localModel).attIndex() >= 0 && ((C45Split)this.m_localModel).attIndex() < data.classAttribute().numValues()) {
                this.m_hasConstr = true;
            }
            this.m_sons = new FTInnerNode[this.m_localModel.numSubsets()];
            int i = 0;
            while (i < this.m_sons.length) {
                this.m_sons[i] = new FTInnerNode(this.m_errorOnProbabilities, this.m_fixedNumIterations, this.m_minNumInstances, this.getWeightTrimBeta(), this.getUseAIC());
                this.m_sons[i].buildTree(localInstances[i], this.mergeArrays(this.m_regressions, this.m_higherRegressions), this.m_totalInstanceWeight, this.m_numParameters);
                localInstances[i] = null;
                ++i;
            }
        } else {
            this.m_leafclass = this.m_localModel.distribution().maxClass();
        }
    }

    @Override
    public double prune() throws Exception {
        double treeError = 0.0;
        double errorsLeaf = this.getEstimatedErrorsForDistribution(this.m_localModel.distribution());
        if (this.m_isLeaf) {
            return errorsLeaf;
        }
        double errorsConstModel = this.getEtimateConstModel(this.m_localModel.distribution());
        double errorsTree = 0.0;
        int i = 0;
        while (i < this.m_sons.length) {
            double probBranch = this.m_localModel.distribution().perBag(i) / this.m_localModel.distribution().total();
            errorsTree += probBranch * this.m_sons[i].prune();
            ++i;
        }
        if (Utils.smOrEq(errorsLeaf, errorsTree)) {
            this.m_sons = null;
            this.m_isLeaf = true;
            this.m_hasConstr = false;
            this.m_leafclass = this.m_localModel.distribution().maxClass();
            this.m_localModel = new NoSplit(this.m_localModel.distribution());
            treeError = errorsLeaf;
        } else {
            treeError = errorsTree;
        }
        return treeError;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] probs;
        if (this.m_isLeaf && this.m_hasConstr) {
            probs = this.modelDistributionForInstance(instance);
        } else if (this.m_isLeaf && !this.m_hasConstr) {
            probs = new double[instance.numClasses()];
            probs[this.m_leafclass] = 1.0;
        } else {
            probs = this.modelDistributionForInstance(instance);
            Instance instanceSplit = new Instance(instance.numAttributes() + instance.numClasses());
            instanceSplit.setDataset(instance.dataset());
            int i = 0;
            while (i < instance.numClasses()) {
                instanceSplit.dataset().insertAttributeAt(new Attribute("N" + (instance.numClasses() - i)), 0);
                instanceSplit.setValue(i, probs[i]);
                ++i;
            }
            i = 0;
            while (i < instance.numAttributes()) {
                instanceSplit.setValue(i + instance.numClasses(), instance.value(i));
                ++i;
            }
            int branch = this.m_localModel.whichSubset(instanceSplit);
            int i2 = 0;
            while (i2 < instance.numClasses()) {
                instanceSplit.dataset().deleteAttributeAt(0);
                ++i2;
            }
            probs = this.m_sons[branch].distributionForInstance(instance);
        }
        return probs;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

