/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq;

import dmLab.array.FArray;
import dmLab.classifier.sliq.AttributeListEvent;
import dmLab.classifier.sliq.AttributeProxyEvent;
import java.util.ArrayList;

final class AttributeList {
    private boolean attrType;
    private int attrIndex;
    private AttributeListEvent[] events;
    private AttributeListEvent[] allEvents;
    private ArrayList<AttributeProxyEvent> proxies;
    private int proxiesNumber;
    private boolean splitStatus;

    public AttributeList(FArray trainArray, int attrIndex) {
        this.attrType = trainArray.attributes[attrIndex].type == 2 || trainArray.attributes[attrIndex].type == 0;
        int eventsNumber = trainArray.rowsNumber();
        int nulls = 0;
        int i = 0;
        while (i < eventsNumber) {
            if (Float.isNaN(trainArray.readValue(attrIndex, i))) {
                ++nulls;
            }
            ++i;
        }
        this.attrIndex = attrIndex;
        this.events = new AttributeListEvent[eventsNumber - nulls];
        this.allEvents = new AttributeListEvent[eventsNumber];
        int j = 0;
        int i2 = 0;
        while (i2 < eventsNumber) {
            float tmp = trainArray.readValue(attrIndex, i2);
            this.allEvents[i2] = new AttributeListEvent();
            this.allEvents[i2].attrValue = tmp;
            this.allEvents[i2].classListIndex = i2;
            if (!Float.isNaN(tmp)) {
                this.events[j] = new AttributeListEvent();
                this.events[j].attrValue = tmp;
                this.events[j].classListIndex = i2;
                ++j;
            }
            ++i2;
        }
        AttributeList attributeList = this;
        this.splitStatus = false;
        attributeList = this;
        attributeList.quickSort(0, attributeList.events.length - 1);
        this.proxiesNumber = this.setProxies();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### attributeList ###\n");
        tmp.append("attrIndex: " + this.attrIndex + " events:").append('\n');
        int i = 0;
        while (i < this.events.length) {
            if (this.events[i] == null) {
                tmp.append("null\n");
            } else {
                tmp.append(this.events[i].toString()).append('\n');
            }
            ++i;
        }
        return var1_1.toString();
    }

    public final void initSplitStatus() {
        this.splitStatus = false;
    }

    public final int getEventsNumber() {
        return this.events.length;
    }

    public final int getAllEventsNumber() {
        return this.allEvents.length;
    }

    public final boolean getAttrType() {
        return this.attrType;
    }

    public final int getAttrIndex() {
        return this.attrIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAttrClassIndex(int eventIndex) {
        void var1_1;
        return this.events[var1_1].classListIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAllAttrClassIndex(int eventIndex) {
        void var1_1;
        return this.allEvents[var1_1].classListIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAttrProxyIndex(int eventIndex) {
        void var1_1;
        return this.events[var1_1].proxyIndex;
    }

    public final boolean getSplitStatus() {
        return this.splitStatus;
    }

    public final void setSplitStatus(boolean splitStatus) {
        this.splitStatus = true;
    }

    /*
     * WARNING - void declaration
     */
    private void quickSort(int l, int r) {
        while (true) {
            void var3_3;
            int i = l;
            int j = r;
            AttributeListEvent x = this.events[(l + r) / 2];
            while (true) {
                if (this.events[i].attrValue < x.attrValue) {
                    ++i;
                    continue;
                }
                while (this.events[j].attrValue > x.attrValue) {
                    --j;
                }
                if (i <= j) {
                    AttributeListEvent w = this.events[i];
                    this.events[i] = this.events[j];
                    this.events[j] = w;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (l < j) {
                this.quickSort(l, j);
            }
            if (i >= r) break;
            l = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int setProxies() {
        void var1_1;
        this.proxies = new ArrayList();
        int proxyIdx = 0;
        float tmpAttrValue = this.events[0].attrValue;
        this.proxies.add(new AttributeProxyEvent(tmpAttrValue));
        this.events[0].proxyIndex = 0;
        int i = 1;
        while (i < this.events.length) {
            if (this.events[i].attrValue != tmpAttrValue) {
                tmpAttrValue = this.events[i].attrValue;
                this.proxies.add(new AttributeProxyEvent(tmpAttrValue));
            }
            this.events[i].proxyIndex = ++proxyIdx;
            ++i;
        }
        return (int)(var1_1 + true);
    }

    public final int getProxiesNumber() {
        return this.proxiesNumber;
    }

    /*
     * WARNING - void declaration
     */
    public final float getAttrProxyValue(int proxyIndex) {
        void var1_1;
        void var2_3 = var1_1;
        AttributeList attributeList = this;
        return attributeList.proxies.get((int)var2_3).attrValue;
    }
}

