/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.ChiSquare;
import jdistlib.F;
import jdistlib.Gamma;
import jdistlib.NonCentralBeta;
import jdistlib.NonCentralChiSquare;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class NonCentralF
extends GenericDistribution {
    protected double df1;
    protected double df2;
    protected double ncp;

    public static final double density(double x, double df1, double df2, double ncp, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(df1) || Double.isNaN(df2) || Double.isNaN(ncp)) {
            return x + df2 + df1 + ncp;
        }
        if (df1 <= 0.0 || df2 <= 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (MathFunctions.isInfinite(ncp)) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(df1) && MathFunctions.isInfinite(df2)) {
            if (x == 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (MathFunctions.isInfinite(df2)) {
            return df1 * NonCentralChiSquare.density(x * df1, df1, ncp, give_log);
        }
        if (df1 > 1.0E14 && ncp < 1.0E7) {
            double f = 1.0 + ncp / df1;
            double z = Gamma.density(1.0 / x / f, df2 / 2.0, 2.0 / df2, give_log);
            return give_log ? z - 2.0 * Math.log(x) - Math.log(f) : z / (x * x) / f;
        }
        double y = df1 / df2 * x;
        double z = NonCentralBeta.density(y / (1.0 + y), df1 / 2.0, df2 / 2.0, ncp, give_log);
        return give_log ? z + Math.log(df1) - Math.log(df2) - 2.0 * Math.log1p(y) : z * (df1 / df2) / (1.0 + y) / (1.0 + y);
    }

    public static final double cumulative(double x, double df1, double df2, double ncp, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(df1) || Double.isNaN(df2) || Double.isNaN(ncp)) {
            return x + df2 + df1 + ncp;
        }
        if (df1 <= 0.0 || df2 <= 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(ncp)) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(df1) && MathFunctions.isInfinite(df2)) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (df2 > 1.0E8) {
            return NonCentralChiSquare.cumulative(x * df1, df1, ncp, lower_tail, log_p);
        }
        double y = df1 / df2 * x;
        return NonCentralBeta.pnbeta2(y / (1.0 + y), 1.0 / (1.0 + y), df1 / 2.0, df2 / 2.0, ncp, lower_tail, log_p);
    }

    public static final double quantile(double p, double df1, double df2, double ncp, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(df1) || Double.isNaN(df2) || Double.isNaN(ncp)) {
            return p + df1 + df2 + ncp;
        }
        if (df1 <= 0.0 || df2 <= 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(ncp)) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(df1) && MathFunctions.isInfinite(df2)) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        if (df2 > 1.0E8) {
            return NonCentralChiSquare.quantile(p, df1, ncp, lower_tail, log_p) / df1;
        }
        double y = NonCentralBeta.quantile(p, df1 / 2.0, df2 / 2.0, ncp, lower_tail, log_p);
        return y / (1.0 - y) * (df2 / df1);
    }

    public static final double random(double df1, double df2, double ncp, RandomEngine random) {
        if (ncp == 0.0) {
            return F.random(df1, df2, random);
        }
        return NonCentralChiSquare.random(df1, ncp, random) / df1 / (ChiSquare.random(df2, random) / df2);
    }

    public static final double[] random(int n, double df1, double df2, double ncp, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = NonCentralF.random(df1, df2, ncp, random);
            ++i;
        }
        return rand;
    }

    public NonCentralF(double df1, double df2, double ncp) {
        this.df1 = df1;
        this.df2 = df2;
        this.ncp = ncp;
    }

    public double density(double x, boolean log) {
        return NonCentralF.density(x, this.df1, this.df2, this.ncp, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return NonCentralF.cumulative(p, this.df1, this.df2, this.ncp, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return NonCentralF.quantile(q, this.df1, this.df2, this.ncp, lower_tail, log_p);
    }

    public double random() {
        return NonCentralF.random(this.df1, this.df2, this.ncp, this.random);
    }
}

