/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.cutoffMethods;

import dmLab.array.functions.DiscFunctions;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.measuresRI.Importance;
import dmLab.mcfs.cutoffMethods.CutoffMethod;
import java.util.Arrays;

public final class CriticalAngleCutoff
extends CutoffMethod {
    /*
     * WARNING - void declaration
     */
    public CriticalAngleCutoff(MCFSParams mcfsParams) {
        super((MCFSParams)var1_1);
        void var1_1;
        this.name = "criticalAngle";
    }

    @Override
    public final double getCutoff(Importance[] importance) {
        Object object;
        double[] dArray = Importance.toValues((Importance[])object);
        object = this;
        double d = 0.0;
        double d2 = ((CriticalAngleCutoff)object).mcfsParams.cutoffAngle;
        Arrays.sort(dArray);
        object = new double[dArray.length];
        double d3 = dArray[0];
        double d4 = dArray[dArray.length - 1] - d3;
        double d5 = 1.0 / (double)dArray.length;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = (dArray[n] - d3) / d4;
            object[n] = (double)n * d5;
            ++n;
        }
        double d6 = CriticalAngleCutoff.linearRegressionAngle((double[])object, dArray, dArray.length - 2);
        int n2 = dArray.length - 3;
        while (n2 > 0) {
            double d7;
            double d8 = CriticalAngleCutoff.linearRegressionAngle((double[])object, dArray, n2);
            if (Math.abs(d7 - d6) < d2) {
                d = dArray[n2] * d4 + d3;
                break;
            }
            d6 = d8;
            --n2;
        }
        System.out.println("Minimal (based on linear regression angle) RI = " + DiscFunctions.format(d, 7));
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static double linearRegressionAngle(double[] xvals, double[] yvals, int shift) {
        void var2_2;
        void var3_3;
        double sumy = 0.0;
        double sumx = 0.0;
        int i = shift;
        while (i < yvals.length) {
            sumy += yvals[i];
            sumx += xvals[i];
            ++i;
        }
        void ybar = var3_3 / (double)yvals.length;
        double xbar = sumx / (double)yvals.length;
        double xxbar = 0.0;
        double xybar = 0.0;
        void i2 = var2_2;
        while (i2 < yvals.length) {
            xxbar += (xvals[i2] - xbar) * (xvals[i2] - xbar);
            xybar += (xvals[i2] - xbar) * (yvals[i2] - ybar);
            ++i2;
        }
        double d = xybar / xxbar;
        return d;
    }
}

