/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.chartPanel;

import dmLab.array.functions.DiscFunctions;
import dmLab.gui.chartPanel.DataSeries;
import dmLab.gui.chartPanel.LineChart;
import dmLab.utils.MathUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public final class MyLineChart
extends LineChart {
    private float[] x;
    private float[] y;
    private float[] xValues;
    private float[] yValues;
    private float maxX;
    private float maxY;
    private float minX;
    private float minY;

    /*
     * WARNING - void declaration
     */
    public MyLineChart(String chartTitle, int imageWidth, int imageHeight) {
        super((String)var1_1, (int)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final BufferedImage draw(ArrayList<DataSeries> series) {
        MyLineChart myLineChart;
        DataSeries s = series.get(0);
        float[] fArray = ((DataSeries)((Object)myLineChart)).y;
        float[] fArray2 = s.x;
        myLineChart = this;
        this.x = (float[])fArray2.clone();
        myLineChart.y = (float[])fArray.clone();
        myLineChart.xValues = (float[])fArray2.clone();
        myLineChart.yValues = (float[])fArray.clone();
        myLineChart.maxX = MathUtils.maxValue(fArray2);
        myLineChart.maxY = MathUtils.maxValue(fArray);
        myLineChart.minX = MathUtils.minValue(fArray2);
        myLineChart.minY = MathUtils.minValue(fArray);
        if (fArray2.length == fArray.length) {
            int n = 0;
            while (n < fArray2.length) {
                if (myLineChart.maxX - myLineChart.minX != 0.0f) {
                    myLineChart.x[n] = (fArray2[n] - myLineChart.minX) / (myLineChart.maxX - myLineChart.minX);
                }
                if (myLineChart.maxY - myLineChart.minY != 0.0f) {
                    myLineChart.y[n] = 1.0f - (fArray[n] - myLineChart.minY) / (myLineChart.maxY - myLineChart.minY);
                }
                ++n;
            }
        }
        return myLineChart.redraw();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BufferedImage redraw() {
        void var1_1;
        if (this.x == null || this.y == null) {
            return null;
        }
        BufferedImage img = new BufferedImage(this.imgWidth, this.imgHeight, 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        Polygon p = new Polygon();
        p.addPoint(0, 0);
        p.addPoint(this.imgWidth, 0);
        p.addPoint(this.imgWidth, this.imgHeight);
        p.addPoint(0, this.imgHeight);
        g.fillPolygon(p);
        g.setColor(Color.black);
        g.drawLine(20, this.imgHeight - 20, this.imgWidth - 20, this.imgHeight - 20);
        g.drawLine(this.imgWidth - 20, this.imgHeight - 20, this.imgWidth - 20 - 5, this.imgHeight - 20 + 5);
        g.drawLine(this.imgWidth - 20, this.imgHeight - 20, this.imgWidth - 20 - 5, this.imgHeight - 20 - 5);
        g.drawLine(20, 20, 20, this.imgHeight - 20);
        g.drawLine(20, 20, 25, 25);
        g.drawLine(20, 20, 15, 25);
        float sizeX = this.imgWidth - 40;
        float sizeY = this.imgHeight - 40;
        int lastCoordinateX = 0;
        int lastCoordinateY = 0;
        if (this.x.length != this.y.length) {
            g.drawString("Error x.length!=y.length", this.imgWidth / 4, this.imgHeight / 2);
        } else {
            int scale = 1;
            if (this.x.length > 10) {
                scale = (int)Math.ceil((double)this.x.length / 10.0);
            }
            if (scale <= 0) {
                scale = 1;
            }
            int i = 0;
            while (i < this.x.length) {
                int coordinateX = (int)(20.0f + sizeX * this.x[i]);
                int coordinateY = (int)(20.0f + sizeY * this.y[i]);
                if (i % scale == 0) {
                    g.drawString(DiscFunctions.format(this.xValues[i], 1), coordinateX, this.imgHeight);
                    g.drawString(DiscFunctions.format(this.yValues[i], 1), 0, coordinateY);
                }
                if (i > 0) {
                    g.drawLine(lastCoordinateX, lastCoordinateY, coordinateX, coordinateY);
                }
                lastCoordinateX = coordinateX;
                lastCoordinateY = coordinateY;
                ++i;
            }
        }
        return var1_1;
    }
}

