/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;

public class SerializedInstancesSaver
extends AbstractFileSaver
implements BatchConverter {
    static final long serialVersionUID = -7717010648500658872L;
    protected ObjectOutputStream m_objectstream;

    public SerializedInstancesSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Serializes the instances to a file with extension bsi.";
    }

    @Override
    public String getFileDescription() {
        return "Binary serialized instances";
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".bsi");
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void resetWriter() {
        super.resetWriter();
        this.m_objectstream = null;
    }

    @Override
    public void setDestination(OutputStream output) throws IOException {
        super.setDestination(output);
        this.m_objectstream = new ObjectOutputStream(output);
    }

    @Override
    public void writeBatch() throws IOException {
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        this.setRetrieval(1);
        if (this.m_objectstream == null) {
            throw new IOException("No output for serialization.");
        }
        this.setWriteMode(0);
        this.m_objectstream.writeObject(this.getInstances());
        this.m_objectstream.flush();
        this.m_objectstream.close();
        this.setWriteMode(1);
        this.resetWriter();
        this.setWriteMode(2);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4907 $");
    }

    public static void main(String[] args) {
        SerializedInstancesSaver.runFileSaver(new SerializedInstancesSaver(), args);
    }
}

