/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.ObjectMatrix3D;
import cern.colt.matrix.impl.DenseObjectMatrix2D;
import cern.colt.matrix.impl.SelectedDenseObjectMatrix3D;

public class DenseObjectMatrix3D
extends ObjectMatrix3D {
    protected Object[] elements;

    public DenseObjectMatrix3D(Object[][][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length, objectArray.length == 0 ? 0 : (objectArray[0].length == 0 ? 0 : objectArray[0][0].length));
        this.assign(objectArray);
    }

    public DenseObjectMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new Object[n * n2 * n3];
    }

    protected DenseObjectMatrix3D(int n, int n2, int n3, Object[] objectArray, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = objectArray;
        this.isNoView = false;
    }

    public ObjectMatrix3D assign(Object[][][] objectArray) {
        if (this.isNoView) {
            if (objectArray.length != this.slices) {
                throw new IllegalArgumentException("Must have same number of slices: slices=" + objectArray.length + "slices()=" + this.slices());
            }
            int n = this.slices * this.rows * this.columns - this.columns;
            int n2 = this.slices;
            while (--n2 >= 0) {
                Object[][] objectArray2 = objectArray[n2];
                if (objectArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray2.length + "rows()=" + this.rows());
                }
                int n3 = this.rows;
                while (--n3 >= 0) {
                    Object[] objectArray3 = objectArray2[n3];
                    if (objectArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray3.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(objectArray3, 0, this.elements, n, this.columns);
                    n -= this.columns;
                }
            }
        } else {
            super.assign(objectArray);
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D objectMatrix3D) {
        if (!(objectMatrix3D instanceof DenseObjectMatrix3D)) {
            return super.assign(objectMatrix3D);
        }
        DenseObjectMatrix3D denseObjectMatrix3D = (DenseObjectMatrix3D)objectMatrix3D;
        if (denseObjectMatrix3D == this) {
            return this;
        }
        this.checkShape(denseObjectMatrix3D);
        if (this.haveSharedCells(denseObjectMatrix3D)) {
            ObjectMatrix3D objectMatrix3D2 = denseObjectMatrix3D.copy();
            if (!(objectMatrix3D2 instanceof DenseObjectMatrix3D)) {
                return super.assign(objectMatrix3D);
            }
            denseObjectMatrix3D = (DenseObjectMatrix3D)objectMatrix3D2;
        }
        if (this.isNoView && denseObjectMatrix3D.isNoView) {
            System.arraycopy(denseObjectMatrix3D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(denseObjectMatrix3D);
    }

    public Object getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D objectMatrix3D) {
        if (objectMatrix3D instanceof SelectedDenseObjectMatrix3D) {
            SelectedDenseObjectMatrix3D selectedDenseObjectMatrix3D = (SelectedDenseObjectMatrix3D)objectMatrix3D;
            return this.elements == selectedDenseObjectMatrix3D.elements;
        }
        if (objectMatrix3D instanceof DenseObjectMatrix3D) {
            DenseObjectMatrix3D denseObjectMatrix3D = (DenseObjectMatrix3D)objectMatrix3D;
            return this.elements == denseObjectMatrix3D.elements;
        }
        return false;
    }

    protected int index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public ObjectMatrix3D like(int n, int n2, int n3) {
        return new DenseObjectMatrix3D(n, n2, n3);
    }

    protected ObjectMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseObjectMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    public void setQuick(int n, int n2, int n3, Object object) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = object;
    }

    protected ObjectMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseObjectMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

