/*
 * Decompiled with CFR 0.152.
 */
package dmLab.experiment;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Params;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;

public class ExperimentParams
extends Params
implements Cloneable {
    public static String DEFAULT_RES_PATH = ".//results//";
    public static String DEFAULT_DATA_PATH = ".//data//";
    public String label;
    public String inputFilesPATH;
    public String resFilesPATH;
    public String classifierCfgPATH;
    public String inputFileName;
    public String[] inputFiles;
    public String testFileName;
    public String outputFileName;

    public ExperimentParams() {
        this.fileType = "run";
        this.setDefault();
    }

    @Override
    public boolean setDefault() {
        this.verbose = true;
        this.debug = false;
        this.label = "experiment";
        this.inputFilesPATH = DEFAULT_DATA_PATH;
        this.resFilesPATH = DEFAULT_RES_PATH;
        this.classifierCfgPATH = ".//cfg//";
        this.inputFileName = "";
        this.testFileName = "";
        this.outputFileName = "";
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(ExperimentParams p) {
        void var1_1;
        super.set(p);
        this.label = p.label;
        this.inputFilesPATH = p.inputFilesPATH;
        this.resFilesPATH = p.resFilesPATH;
        this.classifierCfgPATH = p.classifierCfgPATH;
        this.inputFileName = p.inputFileName;
        this.inputFiles = p.inputFiles;
        this.testFileName = p.testFileName;
        this.outputFileName = var1_1.outputFileName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### Experiment Parameters ### \n");
        tmp.append(super.toString());
        tmp.append("label=" + this.label).append('\n');
        tmp.append("inputFilesPATH=" + this.inputFilesPATH).append('\n');
        tmp.append("resFilesPATH=" + this.resFilesPATH).append('\n');
        tmp.append("classifierCfgPATH=" + this.classifierCfgPATH).append('\n');
        tmp.append("inputFileName=" + this.inputFileName).append('\n');
        if (this.inputFiles != null) {
            tmp.append("inputFiles=" + Arrays.toString(this.inputFiles)).append('\n');
        } else {
            tmp.append("inputFiles=" + this.inputFileName).append('\n');
        }
        if (this.testFileName != null) {
            tmp.append("testFileName=" + this.testFileName).append('\n');
        }
        if (this.outputFileName != null) {
            tmp.append("outputFileName=" + this.outputFileName).append('\n');
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean update(Properties properties) {
        void var1_1;
        String[] stringArray;
        this.verbose = Boolean.valueOf(properties.getProperty("verbose", "true"));
        this.debug = Boolean.valueOf(properties.getProperty("debug", "false"));
        this.label = properties.getProperty("label", "experiment");
        this.inputFilesPATH = properties.getProperty("inputFilesPATH", DEFAULT_DATA_PATH);
        this.resFilesPATH = properties.getProperty("resFilesPATH", DEFAULT_RES_PATH);
        this.classifierCfgPATH = properties.getProperty("classifierCfgPATH", ".//cfg//");
        this.inputFileName = properties.getProperty("inputFileName", "inputFile.adx");
        String[] stringArray2 = this.inputFileName;
        if (this.inputFileName.trim().length() == 0) {
            stringArray = null;
        } else {
            Object[] objectArray = new char[]{',', ';'};
            Object object = new char[]{'\"', '\''};
            stringArray2 = DiscFunctions.tokenize((String)stringArray2, objectArray, (char[])object);
            objectArray = new String[]{"[", "]"};
            object = new HashSet();
            int n = 0;
            while (n < 2) {
                ((HashSet)object).add(objectArray[n]);
                ++n;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (!((HashSet)object).contains(stringArray2[n2])) {
                    arrayList.add(stringArray2[n2]);
                }
                ++n2;
            }
            String[] stringArray3 = new String[1];
            stringArray3 = arrayList.toArray(stringArray3);
            stringArray2 = stringArray3;
            int n3 = stringArray3.length - 1;
            stringArray2[0] = stringArray2[0].trim();
            stringArray2[n3] = stringArray2[n3].trim();
            if (stringArray2[0].startsWith("[")) {
                stringArray2[0] = stringArray2[0].substring(1, stringArray2[0].length()).trim();
            }
            if (stringArray2[n3].endsWith("]")) {
                stringArray2[n3] = stringArray2[n3].substring(0, stringArray2[n3].length() - 1).trim();
            }
            stringArray = this.inputFiles = stringArray2;
        }
        if (this.inputFiles == null) {
            System.err.println("Parameter 'inputFileName' is not defined");
            return false;
        }
        if (this.inputFiles.length > 1) {
            this.inputFileName = this.inputFiles[0];
        }
        this.testFileName = properties.getProperty("testFileName", null);
        this.outputFileName = var1_1.getProperty("outputFileName", null);
        return true;
    }

    @Override
    public boolean check(FArray array) {
        return true;
    }
}

