/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq;

import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.sliq.AttributeList;
import dmLab.classifier.sliq.ClassList;
import dmLab.classifier.sliq.NominalHistogram;
import dmLab.classifier.sliq.SliqNode;
import dmLab.classifier.sliq.SliqParams;
import dmLab.classifier.sliq.SliqTree;
import dmLab.classifier.sliq.Tree.Node;
import dmLab.classifier.sliq.Tree.Tree;
import dmLab.classifier.sliq.Tree.treePruning.mdlTreePruning.MdlTreePruning;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.utils.cmatrix.AccuracyMeasure;
import dmLab.utils.cmatrix.ConfusionMatrix;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;

public final class SliqClassifier
extends Classifier {
    private AttributeList[] attributesLists;
    private ClassList classList;
    private int trainAttrNumber;
    private SliqTree sliqTree;
    private FArray trainArray;
    private SliqParams cfg;

    public SliqClassifier() {
        this.label = "sliq";
        this.params = new SliqParams();
        this.cfg = (SliqParams)this.params;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean saveDefinition(String path, String name) throws IOException {
        void var1_1;
        void var2_2;
        if (this.params.verbose) {
            System.out.print("Saving classifier definition...");
        }
        this.params.save(path, name);
        FileWriter writer = new FileWriter(String.valueOf(path) + "//" + (String)var2_2 + ".tree");
        writer.write(this.toString());
        var1_1.close();
        if (this.params.verbose) {
            System.out.println(" Done!");
        }
        return true;
    }

    @Override
    public final boolean addImportances(AttributesRI[] importances) {
        this.attrSet = new HashSet();
        ExperimentIndicators experimentIndicators = new ExperimentIndicators();
        new ExperimentIndicators().eventsNumber = this.trainSetSize;
        experimentIndicators.predictionQuality = AccuracyMeasure.calcWAcc(this.confusionMatrix.getMatrix());
        this.sliqTree.addInfo(this.trainArray, this.sliqTree.root, experimentIndicators, importances[0], this.attrSet);
        int i = 0;
        while (i < importances.length) {
            importances[i].flushMeasures();
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean train(FArray trainArray) {
        this.trainArray = trainArray;
        this.trainSetSize = trainArray.rowsNumber();
        FArray fArray = trainArray;
        this.trainAttrNumber = fArray.attributes.length;
        this.attributesLists = new AttributeList[this.trainAttrNumber];
        long start = System.currentTimeMillis();
        this.classList = new ClassList(trainArray);
        int decisionIndex = trainArray.getDecAttrIdx();
        int j = 0;
        while (j < this.trainAttrNumber) {
            if (j != decisionIndex) {
                this.attributesLists[j] = new AttributeList(trainArray, j);
            }
            ++j;
        }
        this.sliqTree = new SliqTree(this.classList);
        this.sliqTree.setAttributesNumber(this.trainAttrNumber);
        this.classList.initializeClassNodesRefs(this.sliqTree);
        int level = 0;
        this.classList.calcClassFrequencies$2f9c67c6();
        Object object = this.sliqTree;
        this.sliqTree.calcFreqClassGiniPurity((SliqNode)((Tree)object).root, this.classList);
        while (!this.sliqTree.leafsPurityCheck() && level < this.cfg.maxLevel) {
            int n;
            int n2;
            int n3;
            Object object2;
            Object object3;
            object = this;
            int n4 = 0;
            while (n4 < ((SliqClassifier)object).trainAttrNumber) {
                if (((SliqClassifier)object).attributesLists[n4] != null) {
                    int n5;
                    ((SliqClassifier)object).attributesLists[n4].initSplitStatus();
                    object3 = ((SliqClassifier)object).attributesLists[n4];
                    SliqTree sliqTree = ((SliqClassifier)object).sliqTree;
                    object2 = ((SliqClassifier)object).classList;
                    int n6 = sliqTree.getLeafsSize();
                    if (((AttributeList)object3).getAttrType()) {
                        n5 = 0;
                        while (n5 < n6) {
                            SliqNode sliqNode = sliqTree.getLeaf(n5);
                            if (!sliqNode.getLeafIndicator()) {
                                sliqNode.numericHistogram.init(sliqNode.classFrequencies);
                            }
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < n6) {
                            SliqNode sliqNode = sliqTree.getLeaf(n5);
                            if (!sliqNode.getLeafIndicator()) {
                                sliqNode.nominalHistogram = new NominalHistogram((ClassList)object2, (AttributeList)object3);
                            }
                            ++n5;
                        }
                    }
                    n3 = ((SliqClassifier)object).attributesLists[n4].getEventsNumber();
                    if (((SliqClassifier)object).attributesLists[n4].getAttrType()) {
                        object2 = object;
                        int n7 = ((SliqClassifier)object2).sliqTree.getLeafsSize();
                        int n8 = 0;
                        while (n8 < n7) {
                            object3 = ((SliqClassifier)object2).sliqTree.getLeaf(n8);
                            if (!((Node)object3).getLeafIndicator()) {
                                ((SliqNode)object3).tmpInit();
                            }
                            ++n8;
                        }
                        n2 = 0;
                        while (n2 < n3) {
                            if (!((SliqClassifier)object).classList.getAttrValueLeafPurity(((SliqClassifier)object).attributesLists[n4], n2)) {
                                n = ((SliqClassifier)object).attributesLists[n4].getAttrProxyIndex(n2);
                                SliqNode sliqNode = ((SliqClassifier)object).classList.getAttrValueLeaf(((SliqClassifier)object).attributesLists[n4], n2);
                                if (sliqNode.tmpSplittingValueProxyIndexEval == -1) {
                                    sliqNode.tmpSplittingValueProxyIndexEval = n;
                                }
                                if (sliqNode.tmpSplittingValueProxyIndexEval != n) {
                                    float f;
                                    float f2 = ((SliqClassifier)object).sliqTree.getGoodnessOfSplit(sliqNode, true);
                                    if (f > sliqNode.tmpGoodnessOfSplit) {
                                        sliqNode.tmpGoodnessOfSplit = f2;
                                        sliqNode.tmpSplittingValueProxyIndex = sliqNode.tmpSplittingValueProxyIndexEval;
                                        sliqNode.tmpSplittingValueProxyIndexEval = n;
                                    }
                                }
                                ((SliqClassifier)object).classList.updateToLEftAttrValueLeafNumHist(((SliqClassifier)object).attributesLists[n4], n2);
                            }
                            ++n2;
                        }
                        super.splitsUpdate(((SliqClassifier)object).attributesLists[n4], n4, true);
                    } else {
                        n2 = 0;
                        while (n2 < n3) {
                            if (n4 == 9 && n2 == 8083 && !((SliqClassifier)object).classList.getAttrValueLeafPurity(((SliqClassifier)object).attributesLists[n4], n2)) {
                                ((SliqClassifier)object).classList.incRightAttrValueLeafNomHist(((SliqClassifier)object).attributesLists[n4], n2);
                            }
                            ++n2;
                        }
                        super.splitsUpdate(((SliqClassifier)object).attributesLists[n4], n4, false);
                    }
                }
                ++n4;
            }
            object2 = object;
            int n9 = ((SliqClassifier)object2).sliqTree.getLeafsSize();
            int n10 = 0;
            while (n10 < n9) {
                object3 = ((SliqClassifier)object2).sliqTree.getLeaf(n10);
                if (((SliqNode)object3).attrListSplittingAttrIndex != -1) {
                    ((SliqClassifier)object2).attributesLists[((SliqNode)object3).attrListSplittingAttrIndex].setSplitStatus(true);
                }
                ++n10;
            }
            this.sliqTree.createLeafs(this.classList);
            FArray fArray2 = trainArray;
            object = this;
            int n11 = ((SliqClassifier)object).sliqTree.getLeafsSize();
            n = 0;
            while (n < ((SliqClassifier)object).trainAttrNumber) {
                if (((SliqClassifier)object).attributesLists[n] != null && ((SliqClassifier)object).attributesLists[n].getSplitStatus()) {
                    int n12 = ((SliqClassifier)object).attributesLists[n].getAllEventsNumber();
                    n3 = 0;
                    while (n3 < n12) {
                        n2 = ((SliqClassifier)object).attributesLists[n].getAllAttrClassIndex(n3);
                        SliqNode sliqNode = ((SliqClassifier)object).classList.getClassLeafRef(n2);
                        if (!sliqNode.getLeafIndicator() && sliqNode.attrListSplittingAttrIndex == n) {
                            boolean bl;
                            block39: {
                                int n13 = n2;
                                FArray fArray3 = fArray2;
                                SliqNode sliqNode2 = sliqNode;
                                float f = fArray3.readValue(sliqNode2.getSplittingAttrIndex(), n13);
                                float[] fArray4 = sliqNode2.getSplittingValues();
                                if (sliqNode2.getSplittingAttrType()) {
                                    bl = f <= fArray4[0];
                                } else {
                                    int n14 = 0;
                                    do {
                                        if (f != fArray4[n14]) continue;
                                        bl = true;
                                        break block39;
                                    } while (++n14 < fArray4.length);
                                    bl = false;
                                }
                            }
                            if (bl) {
                                ((SliqClassifier)object).classList.setClassLeafRef(n2, (SliqNode)sliqNode.left);
                            } else {
                                ((SliqClassifier)object).classList.setClassLeafRef(n2, (SliqNode)sliqNode.right);
                            }
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            ((SliqClassifier)object).classList.calcClassFrequencies$2f9c67c6();
            n = 0;
            while (n < n11) {
                SliqNode sliqNode = ((SliqClassifier)object).sliqTree.getLeaf(n);
                if (!sliqNode.getLeafIndicator()) {
                    ((SliqClassifier)object).sliqTree.calcFreqClassGiniPurity(sliqNode, ((SliqClassifier)object).classList);
                }
                ++n;
            }
            if (this.params.verbose) {
                System.out.println("Tree building - level: " + level);
            }
            ++level;
        }
        long stop222 = System.currentTimeMillis();
        this.learningTime = (float)(stop222 - start) / 1000.0f;
        this.sliqTree.setTreeBuildingTime(this.learningTime);
        if (this.cfg.mdlPruning) {
            void var2_5;
            start = System.currentTimeMillis();
            object = this;
            if (((SliqClassifier)object).params.verbose) {
                System.out.println("Prunning the tree...");
            }
            MdlTreePruning stop222 = new MdlTreePruning(((SliqClassifier)object).sliqTree);
            stop222.treePrune();
            if (((SliqClassifier)object).params.verbose) {
                System.out.println("Prunning is finished.");
            }
            long stop222 = System.currentTimeMillis();
            this.learningTime = (float)(stop222 - var2_5) / 1000.0f;
            this.sliqTree.setTreePruningTime(this.learningTime);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_2;
        if (this.params.verbose) {
            System.out.print("Testing...");
        }
        long start = System.currentTimeMillis();
        this.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), testArray.getDecValuesStr());
        int testEventsNumber = testArray.rowsNumber();
        this.predictions = new Prediction[testEventsNumber];
        int decAttrIndex = testArray.getDecAttrIdx();
        int i = 0;
        while (i < testEventsNumber) {
            int n = i;
            FArray fArray = testArray;
            SliqClassifier sliqClassifier = this;
            float predictedDecision = sliqClassifier.sliqTree.classifyEvent(fArray, n);
            float realDecision = testArray.readValue(decAttrIndex, i);
            this.confusionMatrix.add(realDecision, predictedDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predictions[i] = new Prediction(predictedClassName, null);
            ++i;
        }
        long stop = System.currentTimeMillis();
        this.testingTime = (float)(stop - var2_2) / 1000.0f;
        if (this.params.verbose) {
            System.out.println("Testing is finished!");
        }
        return true;
    }

    @Override
    public final boolean init() {
        return true;
    }

    @Override
    public final boolean finish() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### Sliq Classifier ### \n");
        tmp.append("label=" + this.label).append('\n');
        tmp.append(this.sliqTree.toString(this.trainArray, true));
        return var1_1.toString();
    }

    private void splitsUpdate(AttributeList attributeList, int splittingAttrIndex, boolean splittingAttrType) {
        int leafsNumber = this.sliqTree.getLeafsSize();
        if (splittingAttrType) {
            int leafIndex = 0;
            while (leafIndex < leafsNumber) {
                SliqNode node = this.sliqTree.getLeaf(leafIndex);
                if (!node.getLeafIndicator() && node.tmpGoodnessOfSplit > node.getGoodnessOfSplit()) {
                    node.setGoodnessOfSplit(node.tmpGoodnessOfSplit);
                    node.setSplittingAttrIndex(attributeList.getAttrIndex());
                    node.attrListSplittingAttrIndex = splittingAttrIndex;
                    node.setSplittingAttrType(splittingAttrType);
                    float[] fArray = new float[1];
                    float[] splittingValues = fArray;
                    fArray[0] = attributeList.getAttrProxyValue(node.tmpSplittingValueProxyIndex);
                    node.setSplittingValues(splittingValues);
                }
                ++leafIndex;
            }
            return;
        }
        int leafIndex = 0;
        while (leafIndex < leafsNumber) {
            SliqNode node = this.sliqTree.getLeaf(leafIndex);
            if (!node.getLeafIndicator()) {
                float[] splittingValues = this.sliqTree.findBestSubset(node, attributeList);
                if (node.tmpGoodnessOfSplit > node.getGoodnessOfSplit()) {
                    node.setGoodnessOfSplit(node.tmpGoodnessOfSplit);
                    node.setSplittingAttrIndex(attributeList.getAttrIndex());
                    node.attrListSplittingAttrIndex = splittingAttrIndex;
                    node.setSplittingAttrType(splittingAttrType);
                    node.setSplittingValues(splittingValues);
                }
            }
            ++leafIndex;
        }
    }
}

