% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz-place.R
\name{mz_place}
\alias{mz_place}
\alias{mz_place.character}
\alias{mz_place.mapzen_geo_list}
\title{Get details on a place}
\usage{
mz_place(ids, ..., api_key = NULL)

\method{mz_place}{character}(ids, ..., api_key = NULL)

\method{mz_place}{mapzen_geo_list}(ids, ..., gid = "gid",
  api_key = NULL)
}
\arguments{
\item{ids}{A character vector of gids (see details), or a \code{mapzen_geo_list}}

\item{...}{Arguments passed on to methods}

\item{api_key}{Your Mapzen API key. The default is to look for the key within
the provider information that was set up with `mz_set_host`.}

\item{gid}{The name of the \code{gid} field to use. Search results may include,
in addition to the \code{gid} for the search result itself (the default), the
\code{gid}s for the country, region, county, locality and neighborhood.}
}
\description{
Search functions (e.g. \code{\link{mz_search}}) return identification numbers,
or \code{gid}s. Use \code{mz_place} to retrieve more details about the place.
See \url{https://mapzen.com/documentation/search/place/} for details. This
function is generic, and can take a character vector of IDs, or a
\code{mapzen_geo_list} as returned by \code{\link{mz_search}} and friends.
}
